package com.biz.crm.dms.business.costpool.replenishment.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetailLog;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 货补费用池明细记录表(CostPoolReplenishmentDetailLog)表服务接口
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
public interface CostPoolReplenishmentDetailLogService {

  /**
   * 分页查询数据
   *
   * @param pageable                       分页对象
   * @param costPoolReplenishmentDetailLog 实体对象
   * @return
   */
  Page<CostPoolReplenishmentDetailLog> findByConditions(Pageable pageable, CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  CostPoolReplenishmentDetailLog findById(String id);

  /**
   * 新增数据
   *
   * @param costPoolReplenishmentDetailLog 实体对象
   * @return 新增结果
   */
  CostPoolReplenishmentDetailLog create(CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog);

  /**
   * 修改新据
   *
   * @param costPoolReplenishmentDetailLog 实体对象
   * @return 修改结果
   */
  CostPoolReplenishmentDetailLog update(CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog);

  /**
   * 批量新增
   *
   * @param detailLogList
   */
  void createBatch(List<CostPoolReplenishmentDetailLog> detailLogList);
}

