package com.biz.crm.dms.business.costpool.replenishment.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetail;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 货补费用池明细(CostPoolReplenishmentDetail)表服务接口
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
public interface CostPoolReplenishmentDetailService {

  /**
   * 分页查询数据
   *
   * @param pageable                    分页对象
   * @param costPoolReplenishmentDetail 实体对象
   * @return
   */
  Page<CostPoolReplenishmentDetail> findByConditions(Pageable pageable, CostPoolReplenishmentDetail costPoolReplenishmentDetail);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  CostPoolReplenishmentDetail findDetailsById(String id);

  /**
   * 新增数据
   *
   * @param costPoolReplenishmentDetail 实体对象
   * @return 新增结果
   */
  CostPoolReplenishmentDetail create(CostPoolReplenishmentDetail costPoolReplenishmentDetail);

  /**
   * 修改新据
   *
   * @param costPoolReplenishmentDetail 实体对象
   * @return 修改结果
   */
  CostPoolReplenishmentDetail update(CostPoolReplenishmentDetail costPoolReplenishmentDetail);

  /**
   * 批量新增
   *
   * @param replenishmentDetailList
   */
  void createBatch(List<CostPoolReplenishmentDetail> replenishmentDetailList);

  /**
   * 批量更新
   *
   * @param replenishmentDetailList
   */
  void updateBatch(List<CostPoolReplenishmentDetail> replenishmentDetailList);

  /**
   * 费用池编码查询数据集合
   *
   * @param poolCode
   * @return
   */
  List<CostPoolReplenishmentDetail> findByPoolCode(String poolCode);

  /**
   /**
   * 根据费用池编码及来源编码查询（此方法用于审批通过时找到审批前占用的哪个就扣哪个）
   * @param poolCode 费用池编码
   * @param fromCode 来源编码
   * @return
   */
  List<CostPoolReplenishmentDetail> findByPoolCodeAndFromCode(String poolCode, String fromCode);

  /**
   * 调整货补池
   *
   * @param costPoolReplenishmentDto
   */
  void handleAdjust(CostPoolReplenishmentDto costPoolReplenishmentDto);

  /**
   * 根据编码查询对象
   *
   * @param poolDetailCode
   * @return
   */
  CostPoolReplenishmentDetail findByPoolDetailCode(String poolDetailCode);
}

