package com.biz.crm.dms.business.costpool.replenishment.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentFile;
import org.springframework.data.domain.Pageable;

/**
 * 货补费用池附件表(CostPoolReplenishmentFile)表服务接口
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
public interface CostPoolReplenishmentFileService {

  /**
   * 分页查询数据
   *
   * @param pageable                  分页对象
   * @param costPoolReplenishmentFile 实体对象
   * @return
   */
  Page<CostPoolReplenishmentFile> findByConditions(Pageable pageable, CostPoolReplenishmentFile costPoolReplenishmentFile);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  CostPoolReplenishmentFile findById(String id);

  /**
   * 新增数据
   *
   * @param costPoolReplenishmentFile 实体对象
   * @return 新增结果
   */
  CostPoolReplenishmentFile create(CostPoolReplenishmentFile costPoolReplenishmentFile);

  /**
   * 修改新据
   *
   * @param costPoolReplenishmentFile 实体对象
   * @return 修改结果
   */
  CostPoolReplenishmentFile update(CostPoolReplenishmentFile costPoolReplenishmentFile);

}

