package com.biz.crm.dms.business.costpool.replenishment.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOperationDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 货补费用池操作记录表(CostPoolReplenishmentOperation)表服务接口
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
public interface CostPoolReplenishmentOperationService {

  /**
   * 分页查询数据
   *
   * @param pageable                       分页对象
   * @param costPoolReplenishmentOperation 实体对象
   * @return
   */
  Page<CostPoolReplenishmentOperation> findByConditions(Pageable pageable, CostPoolReplenishmentOperation costPoolReplenishmentOperation);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  CostPoolReplenishmentOperation findById(String id);

  /**
   * 新增数据
   *
   * @param costPoolReplenishmentOperation 实体对象
   * @return 新增结果
   */
  CostPoolReplenishmentOperation create(CostPoolReplenishmentOperation costPoolReplenishmentOperation);

  /**
   * 修改新据
   *
   * @param costPoolReplenishmentOperation 实体对象
   * @return 修改结果
   */
  CostPoolReplenishmentOperation update(CostPoolReplenishmentOperation costPoolReplenishmentOperation);

  /**
   * 根据费用池编码集合和时间查询
   *
   * @param dto
   * @return
   */
  List<CostPoolReplenishmentOperation> findByPoolCodesAndDate(CostPoolReplenishmentOperationDto dto);

  /**
   * 根据费用池编码集合和开始时间 查询 开始时间之前的记录
   *
   * @param operationDto
   * @return
   */
  List<CostPoolReplenishmentOperation> findByPoolCodesAndBeforeDate(CostPoolReplenishmentOperationDto operationDto);
}

