package com.biz.crm.dms.business.costpool.replenishment.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 货补费用池主表(CostPoolReplenishment)表服务接口
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
public interface CostPoolReplenishmentService {

  /**
   * 分页查询数据
   *
   * @param pageable              分页对象
   * @param costPoolReplenishment 实体对象
   * @return
   */
  Page<CostPoolReplenishment> findByConditions(Pageable pageable, CostPoolReplenishmentDto costPoolReplenishmentDto);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  CostPoolReplenishment findById(String id);

  /**
   * 新增数据
   *
   * @param costPoolReplenishment 实体对象
   * @return 新增结果
   */
  CostPoolReplenishment create(CostPoolReplenishment costPoolReplenishment);

  /**
   * 修改新据
   *
   * @param costPoolReplenishment 实体对象
   * @return 修改结果
   */
  CostPoolReplenishment update(CostPoolReplenishment costPoolReplenishment);

  /**
   * 根据条件查看数据
   *
   * @param costPoolReplenishmentDto
   * @return
   */
  CostPoolReplenishment findByCostPoolReplenishmentDto(CostPoolReplenishmentDto costPoolReplenishmentDto);

  /**
   * 调整货补池
   *
   * @param costPoolReplenishmentDto
   */
  void handleAdjust(CostPoolReplenishmentDto costPoolReplenishmentDto);

  /**
   * 根据编码查询对象
   *
   * @param poolCode
   * @return
   */
  CostPoolReplenishment findByPoolCode(String poolCode);

  /**
   * 根据费用池编码集合和客户编码查询
   *
   * @param poolCodes
   * @param customerCode
   * @return
   */
  List<CostPoolReplenishment> findByPoolCodesAndCustomerCode(List<String> poolCodes, String customerCode);

  /**
   * 根据客户编码查询
   * @param customerCode
   * @return
   */
  List<CostPoolReplenishment> findByCustomerCode(String customerCode);

}

