package com.biz.crm.dms.business.costpool.replenishment.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentFile;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentFileRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentFileService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Objects;

/**
 * 货补费用池附件表(CostPoolReplenishmentFile)表服务实现类
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
@Service("costPoolReplenishmentFileService")
public class CostPoolReplenishmentFileServiceImpl implements CostPoolReplenishmentFileService {

  @Autowired(required = false)
  private CostPoolReplenishmentFileRepository costPoolReplenishmentFileRepository;

  /**
   * 分页查询数据
   *
   * @param pageable                  分页对象
   * @param costPoolReplenishmentFile 实体对象
   * @return
   */
  @Override
  public Page<CostPoolReplenishmentFile> findByConditions(Pageable pageable, CostPoolReplenishmentFile costPoolReplenishmentFile) {
    pageable=ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(costPoolReplenishmentFile)) {
      costPoolReplenishmentFile = new CostPoolReplenishmentFile();
    }
    return this.costPoolReplenishmentFileRepository.findByConditions(pageable, costPoolReplenishmentFile);
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public CostPoolReplenishmentFile findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.costPoolReplenishmentFileRepository.getById(id);
  }

  /**
   * 新增数据
   *
   * @param costPoolReplenishmentFile 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public CostPoolReplenishmentFile create(CostPoolReplenishmentFile costPoolReplenishmentFile) {
    this.createValidate(costPoolReplenishmentFile);
    this.costPoolReplenishmentFileRepository.saveOrUpdate(costPoolReplenishmentFile);
    return costPoolReplenishmentFile;
  }

  /**
   * 修改新据
   *
   * @param costPoolReplenishmentFile 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public CostPoolReplenishmentFile update(CostPoolReplenishmentFile costPoolReplenishmentFile) {
    this.updateValidate(costPoolReplenishmentFile);
    this.costPoolReplenishmentFileRepository.saveOrUpdate(costPoolReplenishmentFile);
    return costPoolReplenishmentFile;
  }

  /**
   * 创建验证
   *
   * @param costPoolReplenishmentFile
   */
  private void createValidate(CostPoolReplenishmentFile costPoolReplenishmentFile) {
    Validate.notNull(costPoolReplenishmentFile, "新增时，对象信息不能为空！");
    costPoolReplenishmentFile.setId(null);
    Validate.notNull(costPoolReplenishmentFile.getFileName(), "新增数据时，文件名称不能为空！");
    Validate.notNull(costPoolReplenishmentFile.getOperationCode(), "新增数据时，操作记录编号不能为空！");
    Validate.notNull(costPoolReplenishmentFile.getPoolCode(), "新增数据时，费用池编号不能为空！");
    Validate.notNull(costPoolReplenishmentFile.getUrl(), "新增数据时，文件路径不能为空！");

  }

  /**
   * 修改验证
   *
   * @param costPoolReplenishmentFile
   */
  private void updateValidate(CostPoolReplenishmentFile costPoolReplenishmentFile) {
    Validate.notNull(costPoolReplenishmentFile, "修改时，对象信息不能为空！");
    Validate.notBlank(costPoolReplenishmentFile.getId(), "修改数据时，不能为空！");
    Validate.notBlank(costPoolReplenishmentFile.getFileName(), "修改数据时，文件名称不能为空！");
    Validate.notBlank(costPoolReplenishmentFile.getOperationCode(), "修改数据时，操作记录编号不能为空！");
    Validate.notBlank(costPoolReplenishmentFile.getPoolCode(), "修改数据时，费用池编号不能为空！");
    Validate.notBlank(costPoolReplenishmentFile.getUrl(), "修改数据时，文件路径不能为空！");

  }
}

