package com.biz.crm.dms.business.costpool.replenishment.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentOperationRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationVoService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOperationDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.CostPoolReplenishmentOperationGroupEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOperationVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.costpool.replenishment.local.service.internal
 * @ClassName CostPoolReplenishmentOperationVoServiceImpl
 * @Author YangWei
 * @Date 2022/3/23 下午2:47
 * @Description 货补费用操作明细Vo服务接口实现
 */
@Service("costPoolReplenishmentOperationVoService")
public class CostPoolReplenishmentOperationVoServiceImpl implements CostPoolReplenishmentOperationVoService {

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired(required = false)
  private CostPoolReplenishmentRepository costPoolReplenishmentRepository;

  @Autowired(required = false)
  private CostPoolReplenishmentOperationRepository costPoolReplenishmentOperationRepository;

  /**
   * 客户-货补操作明细分页查询
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<CostPoolReplenishmentOperationVo> findByCostPoolReplenishmentOperationDto(Pageable pageable, CostPoolReplenishmentOperationDto dto) {
    LoginUserDetailsForEMS loginUserDetails = this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
    Page<CostPoolReplenishmentOperationVo> pageResultEmpty = new Page<>(0L, 0L, 0L);
    if (StringUtils.isBlank(loginUserDetails.getCustomerCode())) {
      return pageResultEmpty;
    }
    //查询客户货补池
    List<CostPoolReplenishment> costPoolReplenishmentList = this.costPoolReplenishmentRepository
        .findByCustomerCode(loginUserDetails.getCustomerCode());
    if(CollectionUtils.isEmpty(costPoolReplenishmentList)){
      return pageResultEmpty;
    }
    dto.setPoolCodeList(costPoolReplenishmentList.stream().map(CostPoolReplenishment::getPoolCode)
        .collect(Collectors.toList()));
    Validate.notBlank(dto.getGroup(),"上账/使用标识不能为空");
    CostPoolReplenishmentOperationGroupEnum groupEnum = CostPoolReplenishmentOperationGroupEnum.getByDictCode(dto.getGroup());
    Validate.isTrue(!org.springframework.util.ObjectUtils.isEmpty(groupEnum),"上账/使用标识错误");
    List<String> operationTypeList = PoolOperationTypeEnum.getDictCodeByGroupEnum(groupEnum);
    dto.setOperationTypeList(operationTypeList);
    //查询
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    Page<CostPoolReplenishmentOperationVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<CostPoolReplenishmentOperationVo> entityResult = this.costPoolReplenishmentOperationRepository
        .findByCostPoolReplenishmentOperationDto(page, dto);
    return entityResult;
  }
}