package com.biz.crm.dms.business.costpool.replenishment.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentProduct;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentOrderVoRepository;
import com.biz.crm.dms.business.costpool.replenishment.sdk.service.CostPoolReplenishmentOrderVoService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentProductService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOrderPageDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOrderProductVo;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOrderVo;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年03月08日 17:37:00
 */
@Service("costPoolReplenishmentOrderVoServiceImpl")
public class CostPoolReplenishmentOrderVoServiceImpl implements CostPoolReplenishmentOrderVoService {

  @Autowired(required = false)
  private CostPoolReplenishmentOrderVoRepository costPoolReplenishmentOrderVoRepository;
  @Autowired(required = false)
  private CostPoolReplenishmentProductService costPoolReplenishmentProductService;
  @Autowired(required = false)
  private PriceModelVoService priceModelVoService;
  @Autowired(required = false)
  private ProductLevelVoSdkService productLevelVoSdkService;
  @Autowired(required = false)
  private ProductVoService productVoService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 分页查询
   *
   * @param pageable
   * @param costPoolReplenishmentOrderPageDto
   * @return
   */
  @Override
  public Page<CostPoolReplenishmentOrderVo> findByReplenishmentPageDto(Pageable pageable, CostPoolReplenishmentOrderPageDto costPoolReplenishmentOrderPageDto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(costPoolReplenishmentOrderPageDto)) {
      costPoolReplenishmentOrderPageDto = new CostPoolReplenishmentOrderPageDto();
    }
    Page<CostPoolReplenishmentOrderVo> byConditions = this.costPoolReplenishmentOrderVoRepository.findByReplenishmentPageDto(pageable, costPoolReplenishmentOrderPageDto);

    if (Objects.isNull(byConditions)) {
      return byConditions;
    }
    List<CostPoolReplenishmentOrderVo> records = byConditions.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return byConditions;
    }
    //拼接产品
    List<CostPoolReplenishmentOrderVo> newRecords = this.splicingProduct(records);
    //手动筛选产品
    this.screeningProducts(newRecords, costPoolReplenishmentOrderPageDto);
    //补充编码
    for (CostPoolReplenishmentOrderVo vo : newRecords) {
      String poolCode = vo.getPoolCode();
      List<CostPoolReplenishmentOrderProductVo> costPoolReplenishmentProduct = vo.getCostPoolReplenishmentProduct();
      List<CostPoolReplenishmentOrderProductVo> list =new ArrayList<>();
      if (!CollectionUtils.isEmpty(costPoolReplenishmentProduct)) {
        for (CostPoolReplenishmentOrderProductVo v : costPoolReplenishmentProduct) {
          CostPoolReplenishmentOrderProductVo entity =new CostPoolReplenishmentOrderProductVo();
          entity = this.nebulaToolkitService.copyObjectByWhiteList(v, CostPoolReplenishmentOrderProductVo.class, HashSet.class, ArrayList.class);
          entity.setPoolCode(poolCode);
          list.add(entity);
        }
      }
      vo.setCostPoolReplenishmentProduct(list);
    }
    byConditions.setRecords(newRecords);
    return byConditions;
  }

  /**
   * 筛选商品
   *
   * @param dto
   */
  private void screeningProducts(List<CostPoolReplenishmentOrderVo> newRecords, CostPoolReplenishmentOrderPageDto dto) {
    if (StringUtils.isBlank(dto.getGoodsProductName()) && StringUtils.isBlank(dto.getGoodsProductCode())) {
      return;
    }
    if (CollectionUtils.isEmpty(newRecords)) {
      return;
    }
    for (CostPoolReplenishmentOrderVo newRecord : newRecords) {
      List<CostPoolReplenishmentOrderProductVo> newList = new ArrayList<>();
      List<CostPoolReplenishmentOrderProductVo> list = newRecord.getCostPoolReplenishmentProduct();
      if (CollectionUtils.isEmpty(list)) {
        continue;
      }
      if (StringUtils.isNotBlank(dto.getGoodsProductName()) || StringUtils.isNotBlank(dto.getGoodsProductCode())) {
        newList = list.stream()
            .filter(e -> StringUtils.isNotBlank(dto.getGoodsProductName())
                ? e.getGoodsProductName().contains(dto.getGoodsProductName())
                : 0 == 0)
            .filter(e -> StringUtils.isNotBlank(dto.getGoodsProductCode())
                ?  e.getGoodsProductCode().contains(dto.getGoodsProductCode())
                : 0 == 0)
            .collect(Collectors.toList());
      }
      newRecord.setCostPoolReplenishmentProduct(newList);
    }

  }

  /**
   * 补充信息
   *
   * @param records
   * @return
   */
  private List<CostPoolReplenishmentOrderVo> splicingProduct(List<CostPoolReplenishmentOrderVo> records) {
    //费用池编码
    List<String> codes = records.stream().map(CostPoolReplenishmentOrderVo::getPoolCode).collect(Collectors.toList());
    //产品表信息
    List<CostPoolReplenishmentProduct> products = this.costPoolReplenishmentProductService.findByPoolCodes(codes);
    List<String> productCodes = products.stream().map(CostPoolReplenishmentProduct::getGoodsProductCode).collect(Collectors.toList());
    List<ProductVo> detailsByIdsOrProductCodes = this.productVoService.findDetailsByIdsOrProductCodes(new ArrayList<>(0), productCodes);
    Map<String, List<CostPoolReplenishmentProduct>> productMap = products.stream().collect(Collectors.groupingBy(CostPoolReplenishmentProduct::getPoolCode));
    //产品表编码
    List<String> poolCodes = products.stream().map(CostPoolReplenishmentProduct::getPoolCode).collect(Collectors.toList());
    //取差集
    codes.removeAll(poolCodes);
    //存在与产品层级绑定的货补池
    List<String> curAndParentCodes = new ArrayList<>();
    Map<String, List<String>> levelMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(codes)) {
      //获得产品层级编码
      List<String> levelCodes = records.stream()
          .filter(e -> codes.contains(e.getPoolCode()))
          .map(CostPoolReplenishmentOrderVo::getGoodsProductLevelCode)
          .collect(Collectors.toList());
      //查询当前编码及下级
      for (String levelCode : levelCodes) {
        HashSet<String> set = Sets.newHashSet();
        set.add(levelCode);
        List<String> curAndChildrenCodesByCodes = productLevelVoSdkService.findCurAndChildrenCodesByCodes(set);
        levelMap.put(levelCode, curAndChildrenCodesByCodes);
      }
      levelMap.forEach((k, v) -> {
        curAndParentCodes.addAll(v);
      });
    }
    //与产品层级绑定的货补池全部产品
    if (!CollectionUtils.isEmpty(curAndParentCodes)) {
      List<ProductVo> productVos = productVoService.findByProductLevelCodes(curAndParentCodes);
      productCodes.addAll(productVos.stream().map(ProductVo::getProductCode).collect(Collectors.toList()));
    }
    /** 补充产品信息 规格 单位 单价等  **/
    List<CostPoolReplenishmentOrderProductVo> vos = this.supplementProduct(records.get(0).getCustomerCode(), productCodes);
    //
    Map<String, CostPoolReplenishmentOrderProductVo> voMap = vos.stream().collect(Collectors.toMap(CostPoolReplenishmentOrderProductVo::getGoodsProductCode, (v -> v)));
    //将主表绑定的层级与产品相关联
    for (CostPoolReplenishmentOrderVo record : records) {
      List<CostPoolReplenishmentOrderProductVo> newProductList = new ArrayList<>();
      String poolCode = record.getPoolCode();
      //主表存在货补商品
      if (productMap.containsKey(poolCode)) {
        List<CostPoolReplenishmentProduct> list = productMap.get(poolCode);
        for (CostPoolReplenishmentProduct v : list) {
          CostPoolReplenishmentOrderProductVo vo = voMap.get(v.getGoodsProductCode());
          if (vo != null) {
            newProductList.add(vo);
          }
        }
        record.setCostPoolReplenishmentProduct(newProductList);
      } else {
        //主表只存在产品层级
        String goodsProductLevelCode = record.getGoodsProductLevelCode();
        List<String> strings = levelMap.get(goodsProductLevelCode);
        if (!CollectionUtils.isEmpty(strings)) {
          List<CostPoolReplenishmentOrderProductVo> collect = vos.stream().filter(e -> strings.contains(e.getProductLevelCode())).collect(Collectors.toList());
          record.setCostPoolReplenishmentProduct(collect);
        }
      }
    }
    return records;
  }

  /**
   * 补充产品表的产品信息，例如规格，单位,单价等
   *
   * @param productCodes
   */
  private List<CostPoolReplenishmentOrderProductVo> supplementProduct(String customerCode, List<String> productCodes) {
    List<ProductVo> detailsByIdsOrProductCodes = this.productVoService.findDetailsByIdsOrProductCodes(new ArrayList<>(0), productCodes);
    //查询单价
    FindPriceDto findPriceDto =new FindPriceDto();
    findPriceDto.setDimensionCode(PriceDimensionEnum.PRODUCT.getDictCode());
    findPriceDto.setProductCodeSet(Sets.newHashSet(productCodes));
    findPriceDto.setUserCode(customerCode);
    findPriceDto.setUserType(FindPriceUserTypeEnum.CUSTOMER.getDictCode());
    Map<String, PriceModelVo> priceModelVoMap = this.priceModelVoService.findPrice(findPriceDto);
    //手动复制列表
    List<CostPoolReplenishmentOrderProductVo> vos = new ArrayList<>();
    for (ProductVo d : detailsByIdsOrProductCodes) {
      CostPoolReplenishmentOrderProductVo v = new CostPoolReplenishmentOrderProductVo();
      v.setGoodsProductCode(d.getProductCode());
      v.setProductLevelCode(d.getProductLevelCode());
      v.setGoodsProductName(d.getProductName());
      v.setBaseUnit(d.getBaseUnit());
      v.setSpec(d.getSpec());
      v.setSaleUnit(d.getSaleUnit());
      v.setId(d.getId());
      vos.add(v);
    }
    vos.forEach(e -> {
      String goodsProductCode = e.getGoodsProductCode();
      if (priceModelVoMap.containsKey(goodsProductCode)) {
        BigDecimal price = priceModelVoMap.get(goodsProductCode).getPrice();
        e.setPrice(price);
      }
    });
    if (CollectionUtils.isEmpty(vos)) {
      return new ArrayList<>(0);
    }
    return vos;
  }
}
