package com.biz.crm.dms.business.costpool.replenishment.local.service.internal;

import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentProduct;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentProductRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentProductService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author HanJiaJun
 * @describe: 货补产品表服务实现类
 * @createTime 2022年01月18日 10:40:00
 */
@Service
public class CostPoolReplenishmentProductServiceImpl implements CostPoolReplenishmentProductService {


  @Autowired(required = false)
  private CostPoolReplenishmentProductRepository costPoolReplenishmentProductRepository;

  /**
   * 根据费用池编码集合查询关联产品集合
   *
   * @param codes
   * @return
   */
  @Override
  public List<CostPoolReplenishmentProduct> findByPoolCodes(List<String> codes) {
    if (CollectionUtils.isEmpty(codes)){
      return new ArrayList<>(0);
    }
    return this.costPoolReplenishmentProductRepository.findByPoolCodes(codes);
  }

  /**
   * 创建
   * @param list
   */
  @Override
  public void create(List<CostPoolReplenishmentProduct> list) {
    if(CollectionUtils.isEmpty(list)){
      return;
    }
    this.costPoolReplenishmentProductRepository.saveBatch(list);
  }
}
