package com.biz.crm.dms.business.costpool.replenishment.local.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentProduct;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentProductRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentVo;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author HanJiaJun
 * @describe:货补池实现费用池观察者相关接口
 * @createTime 2021年12月31日 11:14:00
 */
@Component
public class CostPoolReplenishmentStrategyImpl implements CostPoolStrategy {

  @Autowired(required = false)
  @Qualifier("CostPoolReplenishmentRegisterImpl")
  private CostPoolRegister costPoolRegister;
  @Autowired(required = false)
  private CostPoolReplenishmentService costPoolReplenishmentService;
  @Autowired(required = false)
  private CostPoolReplenishmentProductRepository costPoolReplenishmentProductRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getPoolTypeRegisterKey() {
    return costPoolRegister.getKey();
  }

  @Override
  public List<CostPoolVo> onRequestCostPoolVos(CostPoolDto costPoolDto) {
    List<CostPoolReplenishment> byPoolCodesAndCustomerCode = new ArrayList<>();
    if (CollectionUtils.isEmpty(costPoolDto.getPoolCodeList())) {
      byPoolCodesAndCustomerCode = this.costPoolReplenishmentService.findByCustomerCode(costPoolDto.getCustomerCode());
    } else {
      byPoolCodesAndCustomerCode = this.costPoolReplenishmentService
          .findByPoolCodesAndCustomerCode(costPoolDto.getPoolCodeList(), costPoolDto.getCustomerCode());
    }
    List<String> poolCodes = byPoolCodesAndCustomerCode.stream().map(CostPoolReplenishment::getPoolCode).collect(Collectors.toList());
    Map<String, List<CostPoolReplenishmentProduct>> productMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(poolCodes)) {
      List<CostPoolReplenishmentProduct> products = this.costPoolReplenishmentProductRepository.findByPoolCodes(poolCodes);
      productMap = products.stream().collect(Collectors.groupingBy(CostPoolReplenishmentProduct::getPoolCode));
    }
    Map<String, List<String>> map = new HashMap<>();
    for (CostPoolReplenishment costPoolReplenishment : byPoolCodesAndCustomerCode) {
      List<CostPoolReplenishmentProduct> costPoolReplenishmentProduct = productMap.get(costPoolReplenishment.getPoolCode());
      costPoolReplenishment.setCostPoolReplenishmentProduct(costPoolReplenishmentProduct);
      if (!CollectionUtils.isEmpty(costPoolReplenishmentProduct)) {
        List<String> list = new ArrayList<>();
        for (CostPoolReplenishmentProduct poolReplenishmentProduct : costPoolReplenishmentProduct) {
          list.add(poolReplenishmentProduct.getGoodsProductCode());
        }
        map.put(costPoolReplenishment.getPoolCode(), list);
      }
    }
    List<CostPoolReplenishmentVo> result = (List<CostPoolReplenishmentVo>) this.nebulaToolkitService.copyCollectionByWhiteList(byPoolCodesAndCustomerCode, CostPoolReplenishment.class, CostPoolReplenishmentVo.class, HashSet.class,
        ArrayList.class, "costPoolReplenishmentProduct");
    for (CostPoolReplenishmentVo costPoolReplenishmentVo : result) {
      if (map.containsKey(costPoolReplenishmentVo.getPoolCode())) {
        List<String> list = map.get(costPoolReplenishmentVo.getPoolCode());
        costPoolReplenishmentVo.setProductCodes(list);
      }
    }
    return (List) result;
  }

  @Override
  public void onHandleAdjust(JSONObject jsonObject) {
    CostPoolReplenishmentDto costPoolReplenishmentDto = JsonUtils.json2Obj(jsonObject.toJSONString(), CostPoolReplenishmentDto.class);
    this.costPoolReplenishmentService.handleAdjust(costPoolReplenishmentDto);
  }

}
