package com.biz.crm.dms.business.costpool.replenishment.local.service.strategy;


import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetail;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetailLog;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentFile;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailLogService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentFileDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentProductDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.strategy.OperationTypeStrategy;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 货补费用池，上账操作类型组实现类
 *
 * @author songjingen
 * @since 2021-12-20 19:45:20
 */
@Component
public class ReplenishmentAccountOperationTypeStrategyImpl implements OperationTypeStrategy {

  @Autowired(required = false)
  private CostPoolReplenishmentService costPoolReplenishmentService;
  @Autowired(required = false)
  private CostPoolReplenishmentDetailService costPoolReplenishmentDetailService;
  @Autowired(required = false)
  private CostPoolReplenishmentDetailLogService costPoolReplenishmentDetailLogService;
  @Autowired(required = false)
  private CostPoolReplenishmentOperationService costPoolReplenishmentOperationService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private ProductLevelVoSdkService productLevelVoSdkService;
  @Autowired(required = false)
  private ProductVoService productVoService;

  @Override
  public String getOperationTypeGroup() {
    return PoolOperationTypeGroupEnum.ACCOUNT.getValue();
  }

  @Override
  @Transactional
  public void onSaveDiscountInfos(CostPoolReplenishmentDto costPoolReplenishmentDto) {
    /**
     * 1、创建货补费用池
     * 2、创建操作记录
     * 3、创建明细
     * 4、创建明细记录
     */
    Date date = new Date();
    BigDecimal amount = costPoolReplenishmentDto.getAmount();
    //1、======
    CostPoolReplenishment costPoolReplenishment = new CostPoolReplenishment();
    CostPoolReplenishment poolReplenishment = null;
    if (StringUtils.isNotBlank(costPoolReplenishmentDto.getPoolCode())) {
      poolReplenishment = this.costPoolReplenishmentService.findByPoolCode(costPoolReplenishmentDto.getPoolCode());
      if (ObjectUtils.isEmpty(poolReplenishment)) {
        throw new IllegalArgumentException("未查询到对应编码的货补池");
      }
    } else {
      //校验产品层级和产品
      validateProductAndLevel(costPoolReplenishmentDto);
      poolReplenishment = this.costPoolReplenishmentService.findByCostPoolReplenishmentDto(costPoolReplenishmentDto);
    }
    if (!Objects.isNull(poolReplenishment)) {
      //如果存在上账类型是期初的则不允许创建，否则可进行修改
      Validate.isTrue(!PoolOperationTypeEnum.INIT.getDictCode().equals(costPoolReplenishmentDto.getOperationType()), "上账类型为期初时，数据已存在不能再期初上账");
      //修改数据
      poolReplenishment.setTotalAmount(poolReplenishment.getTotalAmount().add(amount));
      poolReplenishment.setUsableAmount(poolReplenishment.getUsableAmount().add(amount));
      this.costPoolReplenishmentService.update(poolReplenishment);
      costPoolReplenishment = poolReplenishment;
    } else {
      costPoolReplenishment = this.nebulaToolkitService.copyObjectByWhiteList(costPoolReplenishmentDto, CostPoolReplenishment.class, HashSet.class, ArrayList.class, "costPoolReplenishmentProduct");
      costPoolReplenishment.setPoolCode(String.valueOf(System.currentTimeMillis()));
      costPoolReplenishment.setFreezeAmount(BigDecimal.ZERO);
      costPoolReplenishment.setOccupyAmount(BigDecimal.ZERO);
      costPoolReplenishment.setUsableAmount(amount);
      costPoolReplenishment.setHasUseAmount(BigDecimal.ZERO);
      costPoolReplenishment.setTotalAmount(amount);
      this.costPoolReplenishmentService.create(costPoolReplenishment);
    }
    //2、======
    CostPoolReplenishmentOperation costPoolDiscountOperation = new CostPoolReplenishmentOperation();
    costPoolDiscountOperation.setPoolCode(costPoolReplenishment.getPoolCode());
    costPoolDiscountOperation.setOperationType(costPoolReplenishmentDto.getOperationType());
    costPoolDiscountOperation.setFromCode(costPoolReplenishmentDto.getFromCode());
    costPoolDiscountOperation.setFromDesc(costPoolReplenishmentDto.getFromDesc());
    costPoolDiscountOperation.setOperationDateTime(date);
    costPoolDiscountOperation.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight()));
    Set<CostPoolReplenishmentFileDto> costPoolDiscountFiles = costPoolReplenishmentDto.getCostPoolReplenishmentFileDtos();
    if (!CollectionUtils.isEmpty(costPoolDiscountFiles)) {
      Set<CostPoolReplenishmentFile> files = (Set<CostPoolReplenishmentFile>) this.nebulaToolkitService.copyCollectionByWhiteList(costPoolDiscountFiles, CostPoolReplenishmentFileDto.class, CostPoolReplenishmentFile.class, HashSet.class, ArrayList.class);
      costPoolDiscountOperation.setCostPoolReplenishmentFiles(files);
    }
    costPoolReplenishmentOperationService.create(costPoolDiscountOperation);
    //3、======
    CostPoolReplenishmentDetail costPoolReplenishmentDetail = this.nebulaToolkitService.copyObjectByBlankList(costPoolReplenishment, CostPoolReplenishmentDetail.class, HashSet.class, ArrayList.class, "id");
    costPoolReplenishmentDetail.setFromCode(costPoolReplenishmentDto.getFromCode());
    costPoolReplenishmentDetail.setFromDesc(costPoolReplenishmentDto.getFromDesc());
    costPoolReplenishmentDetail.setOperationType(costPoolReplenishmentDto.getOperationType());
    costPoolReplenishmentDetail.setOperationCode(costPoolDiscountOperation.getOperationCode());
    costPoolReplenishmentDetail.setAccountDateTime(date);
    costPoolReplenishmentDetail.setFreezeAmount(BigDecimal.ZERO);
    costPoolReplenishmentDetail.setOccupyAmount(BigDecimal.ZERO);
    costPoolReplenishmentDetail.setUsableAmount(amount);
    costPoolReplenishmentDetail.setHasUseAmount(BigDecimal.ZERO);
    costPoolReplenishmentDetail.setTotalAmount(amount);
    this.costPoolReplenishmentDetailService.create(costPoolReplenishmentDetail);
    //4、======
    CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog = this.nebulaToolkitService.copyObjectByBlankList(costPoolReplenishmentDetail, CostPoolReplenishmentDetailLog.class, HashSet.class, ArrayList.class, "id");
    costPoolReplenishmentDetailLog.setProductCode(costPoolReplenishmentDto.getGoodsProductLevelCode());
    costPoolReplenishmentDetailLog.setProductName(costPoolReplenishmentDto.getGoodsProductLevelName());
    costPoolReplenishmentDetailLog.setOperationDateTime(date);
    costPoolReplenishmentDetailLog.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight()));
    this.costPoolReplenishmentDetailLogService.create(costPoolReplenishmentDetailLog);
  }

  /**
   * 校验产品层级和产品
   *
   * @param costPoolReplenishmentDto
   */
  private void validateProductAndLevel(CostPoolReplenishmentDto costPoolReplenishmentDto) {
    //校验货补产品层级
    List<ProductLevelVo> listByCodes = productLevelVoSdkService.findListByCodes(Lists.newArrayList(costPoolReplenishmentDto.getGoodsProductLevelCode()));
    Validate.isTrue(!CollectionUtils.isEmpty(listByCodes), "产品层级不存在");
    //校验货补产品
    List<CostPoolReplenishmentProductDto> costPoolReplenishmentProduct = costPoolReplenishmentDto.getCostPoolReplenishmentProduct();
    if (CollectionUtils.isEmpty(costPoolReplenishmentProduct)) {
      return;
    }
    List<String> productCodeList = costPoolReplenishmentProduct.stream()
        .filter(o -> StringUtils.isNotBlank(o.getGoodsProductCode()))
        .map(CostPoolReplenishmentProductDto::getGoodsProductCode)
        .collect(Collectors.toList());
    List<ProductVo> detailsByIdsOrCodes = productVoService.findDetailsByIdsOrProductCodes(new LinkedList<>(), productCodeList);
    Validate.isTrue(!CollectionUtils.isEmpty(detailsByIdsOrCodes), "产品不存在");
    Map<String, ProductVo> productVoMap = new HashMap<>();
    productVoMap.putAll(detailsByIdsOrCodes.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v)));
    productCodeList.forEach(e -> {
      Validate.isTrue(productVoMap.containsKey(e), "产品编码[" + e + "]无效");
    });
    //查询层级和产品的对应关系
    String goodsProductLevelCode = costPoolReplenishmentDto.getGoodsProductLevelCode();
    List<ProductVo> byProductLevelCodes = productVoService.findByProductLevelCodes(Lists.newArrayList(goodsProductLevelCode));
    Validate.isTrue(!CollectionUtils.isEmpty(byProductLevelCodes), "产品层级和产品对应关系不存在");
    Map<String, String> map = byProductLevelCodes.stream().collect(Collectors.toMap(ProductVo::getProductCode, ProductVo::getProductLevelCode));
    for (CostPoolReplenishmentProductDto costPoolReplenishmentProductDto : costPoolReplenishmentDto.getCostPoolReplenishmentProduct()) {
      Validate.isTrue(
          goodsProductLevelCode.equals(
              map.get(costPoolReplenishmentProductDto.getGoodsProductCode())
          ), "商品[" + costPoolReplenishmentProductDto.getGoodsProductCode() + "]不属于产品层级[" + goodsProductLevelCode + "]");
    }
  }
}

