package com.biz.crm.dms.business.costpool.replenishment.local.service.strategy.detail;


import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetail;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetailLog;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentFile;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailLogService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentFileDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.strategy.DetailOperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * 货补费用池明细，扣减操作类型组实现类
 *
 * @author songjingen
 * @since 2021-12-20 19:45:20
 */
@Component
public class ReplenishmentDetailUseOperationTypeStrategyImpl implements DetailOperationTypeStrategy {

  @Autowired(required = false)
  private CostPoolReplenishmentService costPoolReplenishmentService;
  @Autowired(required = false)
  private CostPoolReplenishmentDetailService costPoolReplenishmentDetailService;
  @Autowired(required = false)
  private CostPoolReplenishmentDetailLogService costPoolReplenishmentDetailLogService;
  @Autowired(required = false)
  private CostPoolReplenishmentOperationService costPoolReplenishmentOperationService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getOperationTypeGroup() {
    return PoolOperationTypeGroupEnum.USE.getValue();
  }

  @Override
  @Transactional
  public void onSaveDiscountInfos(CostPoolReplenishmentDto costPoolReplenishmentDto) {
    /**
     * 1、修改货补池明细
     * 2、创建操作记录
     * 3、修改货补池
     * 4、创建明细记录
     */
    Validate.notNull(costPoolReplenishmentDto.getPoolDetailCode(), "进行扣减时，费用池明细编码必传！");
    Date date = new Date();
    BigDecimal amount = costPoolReplenishmentDto.getAmount();
    CostPoolReplenishmentDetail poolReplenishmentDetail = this.costPoolReplenishmentDetailService.findByPoolDetailCode(costPoolReplenishmentDto.getPoolDetailCode());
    Validate.notNull(poolReplenishmentDetail, "进行扣减时未查询到货补池明细信息");
    //1、======
    Validate.isTrue(poolReplenishmentDetail.getUsableAmount().compareTo(amount) >= 0, "进行扣减时，金额不能超过货补池明细可使用金额");
    poolReplenishmentDetail.setHasUseAmount(poolReplenishmentDetail.getHasUseAmount().add(amount));
    poolReplenishmentDetail.setUsableAmount(poolReplenishmentDetail.getUsableAmount().subtract(amount));
    this.costPoolReplenishmentDetailService.update(poolReplenishmentDetail);
    //2、======
    CostPoolReplenishmentOperation costPoolReplenishmentOperation = new CostPoolReplenishmentOperation();
    costPoolReplenishmentOperation.setPoolCode(poolReplenishmentDetail.getPoolCode());
    costPoolReplenishmentOperation.setOperationType(costPoolReplenishmentDto.getOperationType());
    costPoolReplenishmentOperation.setFromCode(costPoolReplenishmentDto.getFromCode());
    costPoolReplenishmentOperation.setFromDesc(costPoolReplenishmentDto.getFromDesc());
    //流水顺序由调用时间区分，保证扣减在释放3000毫秒后的时间
    Date now = new Date();
    Date afterDate = new Date(now.getTime() + 3000);
    costPoolReplenishmentOperation.setCreateTime(afterDate);
    costPoolReplenishmentOperation.setOperationDateTime(afterDate);
    costPoolReplenishmentOperation.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.USE.getUsableAmountWeight()));
    Set<CostPoolReplenishmentFileDto> costPoolDiscountFiles = costPoolReplenishmentDto.getCostPoolReplenishmentFileDtos();
    if (!CollectionUtils.isEmpty(costPoolDiscountFiles)) {
      Set<CostPoolReplenishmentFile> files = (Set<CostPoolReplenishmentFile>) this.nebulaToolkitService.copyCollectionByWhiteList(costPoolDiscountFiles, CostPoolReplenishmentFileDto.class, CostPoolReplenishmentFile.class, HashSet.class, ArrayList.class);
      costPoolReplenishmentOperation.setCostPoolReplenishmentFiles(files);
    }
    this.costPoolReplenishmentOperationService.create(costPoolReplenishmentOperation);
    //3、======
    CostPoolReplenishment costPoolReplenishment = this.costPoolReplenishmentService.findByPoolCode(poolReplenishmentDetail.getPoolCode());
    Validate.notNull(costPoolReplenishment, "进行扣减时未查询到货补池信息");
    Validate.isTrue(costPoolReplenishment.getUsableAmount().compareTo(amount) >= 0, "进行扣减时，金额不能超过货补池可使用金额");
    costPoolReplenishment.setHasUseAmount(costPoolReplenishment.getHasUseAmount().add(amount));
    costPoolReplenishment.setUsableAmount(costPoolReplenishment.getUsableAmount().subtract(amount));
    this.costPoolReplenishmentService.update(costPoolReplenishment);
    //4、======
    CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog = this.nebulaToolkitService.copyObjectByBlankList(poolReplenishmentDetail, CostPoolReplenishmentDetailLog.class, HashSet.class, ArrayList.class, "id");
    costPoolReplenishmentDetailLog.setOperationDateTime(date);
    costPoolReplenishmentDetailLog.setOperationCode(costPoolReplenishmentOperation.getOperationCode());
    costPoolReplenishmentDetailLog.setOperationType(costPoolReplenishmentDto.getOperationType());
    costPoolReplenishmentDetailLog.setFromCode(costPoolReplenishmentDto.getFromCode());
    costPoolReplenishmentDetailLog.setFromDesc(costPoolReplenishmentDto.getFromDesc());
    costPoolReplenishmentDetailLog.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.USE.getUsableAmountWeight()));
    this.costPoolReplenishmentDetailLogService.create(costPoolReplenishmentDetailLog);
  }
}

