/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.replenishment.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.mapper.CostPoolReplenishmentMapper;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class CostPoolReplenishmentRepository
extends ServiceImpl<CostPoolReplenishmentMapper, CostPoolReplenishment> {
    @Autowired(required=false)
    private CostPoolReplenishmentMapper costPoolReplenishmentMapper;

    public Page<CostPoolReplenishment> findByConditions(Pageable pageable, CostPoolReplenishmentDto costPoolReplenishmentDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<CostPoolReplenishment> pageList = this.costPoolReplenishmentMapper.findByConditions((Page<CostPoolReplenishment>)page, costPoolReplenishmentDto);
        return pageList;
    }

    public List<CostPoolReplenishment> findByCostPoolReplenishmentDto(CostPoolReplenishmentDto costPoolReplenishmentDto) {
        return this.costPoolReplenishmentMapper.findByCostPoolReplenishmentDto(costPoolReplenishmentDto);
    }

    public CostPoolReplenishment findByPoolCode(String poolCode) {
        return (CostPoolReplenishment)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CostPoolReplenishment::getPoolCode, (Object)poolCode)).one());
    }

    public List<CostPoolReplenishment> findByPoolCodesAndCustomerCode(List<String> poolCodes, String customerCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CostPoolReplenishment::getPoolCode, poolCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(CostPoolReplenishment::getCustomerCode, (Object)customerCode)).list();
    }

    public List<CostPoolReplenishment> findByCustomerCode(String customerCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(CostPoolReplenishment::getCustomerCode, (Object)customerCode)).list();
    }
}

