/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.replenishment.local.service.strategy.detail;

import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetail;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetailLog;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentFile;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailLogService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentFileDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.strategy.DetailOperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class ReplenishmentDetailOccupyUseOperationTypeStrategyImpl
implements DetailOperationTypeStrategy {
    @Autowired(required=false)
    private CostPoolReplenishmentService costPoolReplenishmentService;
    @Autowired(required=false)
    private CostPoolReplenishmentDetailService costPoolReplenishmentDetailService;
    @Autowired(required=false)
    private CostPoolReplenishmentDetailLogService costPoolReplenishmentDetailLogService;
    @Autowired(required=false)
    private CostPoolReplenishmentOperationService costPoolReplenishmentOperationService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getOperationTypeGroup() {
        return PoolOperationTypeGroupEnum.OCCUPY_USE.getValue();
    }

    @Transactional
    public void onSaveDiscountInfos(CostPoolReplenishmentDto costPoolReplenishmentDto) {
        Validate.notNull((Object)costPoolReplenishmentDto.getPoolDetailCode(), (String)"\u8fdb\u884c\u5360\u7528\u4f7f\u7528\u65f6\uff0c\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u7801\u5fc5\u4f20\uff01", (Object[])new Object[0]);
        Date date = new Date();
        BigDecimal amount = costPoolReplenishmentDto.getAmount();
        CostPoolReplenishmentDetail poolReplenishmentDetail = this.costPoolReplenishmentDetailService.findByPoolDetailCode(costPoolReplenishmentDto.getPoolDetailCode());
        Validate.notNull((Object)((Object)poolReplenishmentDetail), (String)"\u8fdb\u884c\u5360\u7528\u4f7f\u7528\u65f6\u672a\u67e5\u8be2\u5230\u8d27\u8865\u6c60\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((poolReplenishmentDetail.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5360\u7528\u4f7f\u7528\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u8d27\u8865\u6c60\u660e\u7ec6\u53ef\u4f7f\u7528\u91d1\u989d", (Object[])new Object[0]);
        poolReplenishmentDetail.setOccupyAmount(poolReplenishmentDetail.getOccupyAmount().add(amount));
        poolReplenishmentDetail.setUsableAmount(poolReplenishmentDetail.getUsableAmount().subtract(amount));
        this.costPoolReplenishmentDetailService.update(poolReplenishmentDetail);
        CostPoolReplenishmentOperation costPoolReplenishmentOperation = new CostPoolReplenishmentOperation();
        costPoolReplenishmentOperation.setPoolCode(poolReplenishmentDetail.getPoolCode());
        costPoolReplenishmentOperation.setOperationType(costPoolReplenishmentDto.getOperationType());
        costPoolReplenishmentOperation.setFromCode(costPoolReplenishmentDto.getFromCode());
        costPoolReplenishmentOperation.setFromDesc(costPoolReplenishmentDto.getFromDesc());
        costPoolReplenishmentOperation.setOperationDateTime(date);
        costPoolReplenishmentOperation.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.OCCUPY_USE.getUsableAmountWeight()));
        Set costPoolDiscountFiles = costPoolReplenishmentDto.getCostPoolReplenishmentFileDtos();
        if (!CollectionUtils.isEmpty((Collection)costPoolDiscountFiles)) {
            Set files = (Set)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)costPoolDiscountFiles, CostPoolReplenishmentFileDto.class, CostPoolReplenishmentFile.class, HashSet.class, ArrayList.class, new String[0]);
            costPoolReplenishmentOperation.setCostPoolReplenishmentFiles(files);
        }
        this.costPoolReplenishmentOperationService.create(costPoolReplenishmentOperation);
        CostPoolReplenishment costPoolReplenishment = this.costPoolReplenishmentService.findByPoolCode(poolReplenishmentDetail.getPoolCode());
        Validate.notNull((Object)((Object)costPoolReplenishment), (String)"\u8fdb\u884c\u5360\u7528\u4f7f\u7528\u65f6\u672a\u67e5\u8be2\u5230\u8d27\u8865\u6c60\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((costPoolReplenishment.getUsableAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5360\u7528\u4f7f\u7528\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u8d27\u8865\u6c60\u53ef\u4f7f\u7528\u91d1\u989d", (Object[])new Object[0]);
        costPoolReplenishment.setOccupyAmount(costPoolReplenishment.getOccupyAmount().add(amount));
        costPoolReplenishment.setUsableAmount(costPoolReplenishment.getUsableAmount().subtract(amount));
        this.costPoolReplenishmentService.update(costPoolReplenishment);
        CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog = (CostPoolReplenishmentDetailLog)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)poolReplenishmentDetail, CostPoolReplenishmentDetailLog.class, HashSet.class, ArrayList.class, new String[]{"id"}));
        costPoolReplenishmentDetailLog.setOperationDateTime(date);
        costPoolReplenishmentDetailLog.setOperationCode(costPoolReplenishmentOperation.getOperationCode());
        costPoolReplenishmentDetailLog.setOperationType(costPoolReplenishmentDto.getOperationType());
        costPoolReplenishmentDetailLog.setFromCode(costPoolReplenishmentDto.getFromCode());
        costPoolReplenishmentDetailLog.setFromDesc(costPoolReplenishmentDto.getFromDesc());
        costPoolReplenishmentDetailLog.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.OCCUPY_USE.getUsableAmountWeight()));
        this.costPoolReplenishmentDetailLogService.create(costPoolReplenishmentDetailLog);
    }
}

