package com.biz.crm.dms.business.costpool.replenishment.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 货补费用池主表(CostPoolReplenishment)表相关的http接口
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
@RestController
@RequestMapping("/v1/replenishment/costPoolReplenishment")
@Slf4j
@Api(tags = "货补费用池主表:CostPoolReplenishment:货补费用池主表")
public class CostPoolReplenishmentController {
  /**
   * 服务对象
   */
  @Autowired(required = false)
  private CostPoolReplenishmentService costPoolReplenishmentService;

  /**
   * 分页查询所有数据
   *
   * @param pageable              分页对象
   * @param costPoolReplenishmentDto 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<CostPoolReplenishment>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "costPoolReplenishmentDto", value = "货补费用池主表") CostPoolReplenishmentDto costPoolReplenishmentDto) {
    try {
      Page<CostPoolReplenishment> page = this.costPoolReplenishmentService.findByConditions(pageable, costPoolReplenishmentDto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<CostPoolReplenishment> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      CostPoolReplenishment costPoolReplenishment = this.costPoolReplenishmentService.findById(id);
      return Result.ok(costPoolReplenishment);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 调整货补池
   *
   * @param costPoolReplenishmentDto 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "调整货补池")
  @PostMapping("handleAdjust")
  public Result<?> handleAdjust(@ApiParam(name = "CostPoolDiscount", value = "货补池请求对象") @RequestBody CostPoolReplenishmentDto costPoolReplenishmentDto) {
    try {
      this.costPoolReplenishmentService.handleAdjust(costPoolReplenishmentDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
