package com.biz.crm.dms.business.costpool.replenishment.local.controller;



import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetailLog;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 货补费用池明细记录表(CostPoolReplenishmentDetailLog)表相关的http接口
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
@RestController
@RequestMapping("/v1/replenishment/costPoolReplenishmentDetailLog")
@Slf4j
@Api(tags = "货补费用池明细记录表:CostPoolReplenishmentDetailLog:货补费用池明细记录表")
public class CostPoolReplenishmentDetailLogController {
  /**
   * 服务对象
   */
  @Autowired(required = false)
  private CostPoolReplenishmentDetailLogService costPoolReplenishmentDetailLogService;

  /**
   * 分页查询所有数据
   *
   * @param pageable                       分页对象
   * @param costPoolReplenishmentDetailLog 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<CostPoolReplenishmentDetailLog>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                       @ApiParam(name = "costPoolReplenishmentDetailLog", value = "货补费用池明细记录表") CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog) {
    try {
      Page<CostPoolReplenishmentDetailLog> page = this.costPoolReplenishmentDetailLogService.findByConditions(pageable, costPoolReplenishmentDetailLog);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<CostPoolReplenishmentDetailLog> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog = this.costPoolReplenishmentDetailLogService.findById(id);
      return Result.ok(costPoolReplenishmentDetailLog);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param costPoolReplenishmentDetailLog 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<CostPoolReplenishmentDetailLog> create(@ApiParam(name = "costPoolReplenishmentDetailLog", value = "货补费用池明细记录表") @RequestBody CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog) {
    try {
      CostPoolReplenishmentDetailLog result = this.costPoolReplenishmentDetailLogService.create(costPoolReplenishmentDetailLog);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
