package com.biz.crm.dms.business.costpool.replenishment.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 货补费用池操作记录表(CostPoolReplenishmentOperation)表相关的http接口
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
@RestController
@RequestMapping("/v1/replenishment/costPoolReplenishmentOperation")
@Slf4j
@Api(tags = "货补费用池操作记录表:CostPoolReplenishmentOperation:货补费用池操作记录表")
public class CostPoolReplenishmentOperationController {
  /**
   * 服务对象
   */
  @Autowired(required = false)
  private CostPoolReplenishmentOperationService costPoolReplenishmentOperationService;

  /**
   * 分页查询所有数据
   *
   * @param pageable                       分页对象
   * @param costPoolReplenishmentOperation 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<CostPoolReplenishmentOperation>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                       @ApiParam(name = "costPoolReplenishmentOperation", value = "货补费用池操作记录表") CostPoolReplenishmentOperation costPoolReplenishmentOperation) {
    try {
      Page<CostPoolReplenishmentOperation> page = this.costPoolReplenishmentOperationService.findByConditions(pageable, costPoolReplenishmentOperation);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<CostPoolReplenishmentOperation> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      CostPoolReplenishmentOperation costPoolReplenishmentOperation = this.costPoolReplenishmentOperationService.findById(id);
      return Result.ok(costPoolReplenishmentOperation);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param costPoolReplenishmentOperation 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<CostPoolReplenishmentOperation> create(@ApiParam(name = "costPoolReplenishmentOperation", value = "货补费用池操作记录表") @RequestBody CostPoolReplenishmentOperation costPoolReplenishmentOperation) {
    try {
      CostPoolReplenishmentOperation result = this.costPoolReplenishmentOperationService.create(costPoolReplenishmentOperation);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
