package com.biz.crm.dms.business.costpool.replenishment.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author HanJiaJun
 * @describe:货补费用池主表
 * @createTime 2021年12月27日 17:21:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("dms_cost_pool_replenishment")
@Entity
@Table(name = "dms_cost_pool_replenishment", indexes = {
    @Index(columnList = "pool_code,tenant_code", unique = true)
    ,@Index(columnList = "tenant_code")})
@org.hibernate.annotations.Table(appliesTo = "dms_cost_pool_replenishment", comment = "货补费用池主表")
public class CostPoolReplenishment extends TenantFlagOpEntity {


  /**
   * 费用池编号
   */
  @Column(name = "pool_code", nullable = false, unique = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用池编号'")
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;
  /**
   * 费用池分组
   */
  @Column(name = "pool_group", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用池分组'")
  @ApiModelProperty(value = "费用池分组")
  private String poolGroup;
  /**
   * 费用池类型
   */
  @Column(name = "pool_type", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用池类型'")
  @ApiModelProperty(value = "费用池类型")
  private String poolType;
  /**
   * 支付方式
   */
  @Column(name = "pay_type", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '支付方式'")
  @ApiModelProperty(value = "支付方式")
  private String payType;
  /**
   * 费用使用类型
   */
  @Column(name = "use_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) COMMENT '费用使用类型'")
  @ApiModelProperty(value = "费用使用类型")
  private String useType;
  /**
   * 客户编码
   */
  @Column(name = "customer_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
  @ApiModelProperty(value = "客户编码")
  private String customerCode;
  /**
   * 客户名称
   */
  @Column(name = "customer_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
  @ApiModelProperty(value = "客户名称")
  private String customerName;
  /**
   * 渠道类型（项目上自行存值）
   */
  @Column(name = "channel_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道类型（项目上自行存值）'")
  @ApiModelProperty(value = "渠道类型")
  private String channelType;
  /**
   * 组织编码（项目上自行存值）
   */
  @Column(name = "org_code", length = 255, columnDefinition = "VARCHAR(255) COMMENT '组织编码（项目上自行存值）'")
  @ApiModelProperty(value = "组织编码")
  private String orgCode;
  /**
   * 组织名称（项目上自行存值）
   */
  @Column(name = "org_name", length = 500, columnDefinition = "VARCHAR(500) COMMENT '组织名称（项目上自行存值）'")
  @ApiModelProperty(value = "组织名称")
  private String orgName;
  /**
   * 货补产品层级编码
   */
  @Column(name = "goods_product_level_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '货补产品层级编码'")
  @ApiModelProperty(value = "货补产品层级编码")
  private String goodsProductLevelCode;
  /**
   * 货补产品层级名称
   */
  @Column(name = "goods_product_level_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '货补产品层级名称'")
  @ApiModelProperty(value = "货补产品层级名称")
  private String goodsProductLevelName;
  /**
   * 总金额（数量）
   */
  @Column(name = "total_amount", nullable = false, columnDefinition = "decimal(20,4) COMMENT '总金额（数量）'")
  @ApiModelProperty(value = "总金额")
  private BigDecimal totalAmount;
  /**
   * 冻结金额（数量）
   */
  @Column(name = "freeze_amount", nullable = false, columnDefinition = "decimal(20,4) COMMENT '冻结金额（数量）'")
  @ApiModelProperty(value = "冻结金额")
  private BigDecimal freezeAmount;
  /**
   * 占用金额（数量）
   */
  @Column(name = "occupy_amount", nullable = false, columnDefinition = "decimal(20,4) COMMENT '占用金额（数量）'")
  @ApiModelProperty(value = "占用金额")
  private BigDecimal occupyAmount;
  /**
   * 已使用金额（数量）
   */
  @Column(name = "has_use_amount", nullable = false, columnDefinition = "decimal(20,4) COMMENT '已使用金额（数量）'")
  @ApiModelProperty(value = "已使用金额")
  private BigDecimal hasUseAmount;
  /**
   * 剩余可使用金额（数量）
   */
  @Column(name = "usable_amount", nullable = false, columnDefinition = "decimal(20,4) COMMENT '剩余可使用金额（数量）'")
  @ApiModelProperty(value = "剩余可使用金额")
  private BigDecimal usableAmount;
  /**
   * 货补商品
   */
  @TableField(exist = false)
  @Transient
  @ApiModelProperty(value = "货补商品")
  private List<CostPoolReplenishmentProduct> costPoolReplenishmentProduct;
}
