package com.biz.crm.dms.business.costpool.replenishment.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOperationDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOperationVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 货补费用池操作记录表(CostPoolReplenishmentOperation)表mybatis访问层
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
public interface CostPoolReplenishmentOperationMapper extends BaseMapper<CostPoolReplenishmentOperation> {

  /**
   * 分页查询所有数据
   *
   * @param page                           分页对象
   * @param costPoolReplenishmentOperation 查询实体
   * @return 所有数据
   */
  public Page<CostPoolReplenishmentOperation> findByConditions(@Param("page") Page<CostPoolReplenishmentOperation> page, @Param("costPoolReplenishmentOperation") CostPoolReplenishmentOperation costPoolReplenishmentOperation);

  /**
   * 客户-货补操作明细分页查询
   * @param page
   * @param dto
   * @return
   */
  Page<CostPoolReplenishmentOperationVo> findByCostPoolReplenishmentOperationDto(Page<CostPoolReplenishmentOperationVo> page, @Param("dto") CostPoolReplenishmentOperationDto dto);

  /**
   * 通过客户编码集合和时间查询
   * @param dto
   * @return
   */
  List<CostPoolReplenishmentOperation> findByPoolCodesAndDate(@Param("dto") CostPoolReplenishmentOperationDto dto);
}

