package com.biz.crm.dms.business.costpool.replenishment.local.repository;


import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetailLog;
import com.biz.crm.dms.business.costpool.replenishment.local.mapper.CostPoolReplenishmentDetailLogMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;


/**
 * 货补费用池明细记录表(CostPoolReplenishmentDetailLog)表数据库访问层
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
@Component
public class CostPoolReplenishmentDetailLogRepository extends ServiceImpl<CostPoolReplenishmentDetailLogMapper, CostPoolReplenishmentDetailLog> {

  @Autowired(required = false)
  private CostPoolReplenishmentDetailLogMapper costPoolReplenishmentDetailLogMapper;

  /**
   * 分页查询数据
   *
   * @param pageable                       分页对象
   * @param costPoolReplenishmentDetailLog 实体对象
   * @return
   */
  public Page<CostPoolReplenishmentDetailLog> findByConditions(Pageable pageable, CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog) {
    Page<CostPoolReplenishmentDetailLog> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CostPoolReplenishmentDetailLog> pageList = costPoolReplenishmentDetailLogMapper.findByConditions(page, costPoolReplenishmentDetailLog);
    return pageList;
  }
}

