package com.biz.crm.dms.business.costpool.replenishment.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetail;
import com.biz.crm.dms.business.costpool.replenishment.local.mapper.CostPoolReplenishmentDetailMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 货补费用池明细(CostPoolReplenishmentDetail)表数据库访问层
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
@Component
public class CostPoolReplenishmentDetailRepository extends ServiceImpl<CostPoolReplenishmentDetailMapper, CostPoolReplenishmentDetail> {

  @Autowired(required = false)
  private CostPoolReplenishmentDetailMapper costPoolReplenishmentDetailMapper;

  /**
   * 分页查询数据
   *
   * @param pageable                    分页对象
   * @param costPoolReplenishmentDetail 实体对象
   * @return
   */
  public Page<CostPoolReplenishmentDetail> findByConditions(Pageable pageable, CostPoolReplenishmentDetail costPoolReplenishmentDetail) {
    Page<CostPoolReplenishmentDetail> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CostPoolReplenishmentDetail> pageList = costPoolReplenishmentDetailMapper.findByConditions(page, costPoolReplenishmentDetail);
    return pageList;
  }

  public List<CostPoolReplenishmentDetail> findByPoolCode(String poolCode) {
    return this.lambdaQuery()
        .eq(CostPoolReplenishmentDetail::getPoolCode, poolCode)
        .orderByAsc(CostPoolReplenishmentDetail::getAccountDateTime)
        .list();
  }

  /**
   * 根据费用池编码及来源编码查询（此方法用于审批通过时找到审批前占用的哪个就扣哪个）
   * @param poolCode 费用池编码
   * @param fromCode 来源编码
   * @return
   */
  public List<CostPoolReplenishmentDetail> findByPoolCodeAndFromCode(String poolCode, String fromCode) {
    return this.lambdaQuery()
        .eq(CostPoolReplenishmentDetail::getPoolCode, poolCode)
        .eq(CostPoolReplenishmentDetail::getFromCode, fromCode)
        .orderByAsc(CostPoolReplenishmentDetail::getAccountDateTime)
        .list();
  }

  /**
   * 根据编码查询对象
   * @param poolDetailCode
   * @return
   */
  public CostPoolReplenishmentDetail findByPoolDetailCode(String poolDetailCode) {
    return this.lambdaQuery().eq(CostPoolReplenishmentDetail::getPoolDetailCode, poolDetailCode).one();
  }
}

