package com.biz.crm.dms.business.costpool.replenishment.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentProduct;
import com.biz.crm.dms.business.costpool.replenishment.local.mapper.CostPoolReplenishmentProductMapper;
import jodd.util.StringUtil;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe: 货补商品表数据库访问层
 * @createTime 2022年01月18日 14:32:00
 */
@Component
public class CostPoolReplenishmentProductRepository extends ServiceImpl<CostPoolReplenishmentProductMapper, CostPoolReplenishmentProduct> {
  /**
   * 根据编码集合查询
   *
   * @param codes
   * @return
   */
  public List<CostPoolReplenishmentProduct> findByPoolCodes(List<String> codes) {
    return this.lambdaQuery()
        .in(CostPoolReplenishmentProduct::getPoolCode, codes)
        .list();
  }
}
