package com.biz.crm.dms.business.costpool.replenishment.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.mapper.CostPoolReplenishmentMapper;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 货补费用池主表(CostPoolReplenishment)表数据库访问层
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
@Component
public class CostPoolReplenishmentRepository extends ServiceImpl<CostPoolReplenishmentMapper, CostPoolReplenishment> {

  @Autowired(required = false)
  private CostPoolReplenishmentMapper costPoolReplenishmentMapper;

  /**
   * 分页查询数据
   *
   * @param pageable              分页对象
   * @param costPoolReplenishmentDto 实体对象
   * @return
   */
  public Page<CostPoolReplenishment> findByConditions(Pageable pageable, CostPoolReplenishmentDto costPoolReplenishmentDto) {
    Page<CostPoolReplenishment> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CostPoolReplenishment> pageList = costPoolReplenishmentMapper.findByConditions(page, costPoolReplenishmentDto);
    return pageList;
  }

  /**
   * 根据条件查看数据
   *
   * @param costPoolReplenishmentDto
   * @return
   */
  public List<CostPoolReplenishment> findByCostPoolReplenishmentDto(CostPoolReplenishmentDto costPoolReplenishmentDto) {
    return this.costPoolReplenishmentMapper.findByCostPoolReplenishmentDto(costPoolReplenishmentDto);
  }

  /**
   * 通过费用池编码查询
   *
   * @param poolCode
   * @return
   */
  public CostPoolReplenishment findByPoolCode(String poolCode) {
    return this.lambdaQuery().eq(CostPoolReplenishment::getPoolCode, poolCode).one();
  }

  /**
   * 根据费用池编码集合和客户编码查询
   *
   * @param poolCodes
   * @param customerCode
   * @return
   */
  public List<CostPoolReplenishment> findByPoolCodesAndCustomerCode(List<String> poolCodes, String customerCode) {
    return this.lambdaQuery()
        .in(CostPoolReplenishment::getPoolCode, poolCodes)
        .eq(CostPoolReplenishment::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(CostPoolReplenishment::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .eq(CostPoolReplenishment::getCustomerCode, customerCode)
        .list();
  }

  /**
   * 通过客户编码查询
   * @param customerCode
   * @return
   */
  public List<CostPoolReplenishment> findByCustomerCode(String customerCode) {
    return this.lambdaQuery()
        .eq(CostPoolReplenishment::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(CostPoolReplenishment::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .eq(CostPoolReplenishment::getCustomerCode, customerCode)
        .list();
  }
}

