package com.biz.crm.dms.business.costpool.replenishment.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetailLog;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentDetailLogRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailLogService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 货补费用池明细记录表(CostPoolReplenishmentDetailLog)表服务实现类
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
@Service("costPoolReplenishmentDetailLogService")
public class CostPoolReplenishmentDetailLogServiceImpl implements CostPoolReplenishmentDetailLogService {

  @Autowired(required = false)
  private CostPoolReplenishmentDetailLogRepository costPoolReplenishmentDetailLogRepository;

  /**
   * 分页查询数据
   *
   * @param pageable                       分页对象
   * @param costPoolReplenishmentDetailLog 实体对象
   * @return
   */
  @Override
  public Page<CostPoolReplenishmentDetailLog> findByConditions(Pageable pageable, CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog) {
    pageable=ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(costPoolReplenishmentDetailLog)) {
      costPoolReplenishmentDetailLog = new CostPoolReplenishmentDetailLog();
    }
    return this.costPoolReplenishmentDetailLogRepository.findByConditions(pageable, costPoolReplenishmentDetailLog);
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public CostPoolReplenishmentDetailLog findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.costPoolReplenishmentDetailLogRepository.getById(id);
  }

  /**
   * 新增数据
   *
   * @param costPoolReplenishmentDetailLog 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public CostPoolReplenishmentDetailLog create(CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog) {
    this.createValidate(costPoolReplenishmentDetailLog);
    this.costPoolReplenishmentDetailLogRepository.saveOrUpdate(costPoolReplenishmentDetailLog);
    return costPoolReplenishmentDetailLog;
  }

  /**
   * 修改新据
   *
   * @param costPoolReplenishmentDetailLog 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public CostPoolReplenishmentDetailLog update(CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog) {
    this.updateValidate(costPoolReplenishmentDetailLog);
    this.costPoolReplenishmentDetailLogRepository.saveOrUpdate(costPoolReplenishmentDetailLog);
    return costPoolReplenishmentDetailLog;
  }

  /**
   * 批量新增
   *
   * @param detailLogList
   */
  @Override
  public void createBatch(List<CostPoolReplenishmentDetailLog> detailLogList) {
    if (CollectionUtils.isEmpty(detailLogList)) {
      return;
    }
    detailLogList.forEach(e -> {
      this.createValidate(e);
    });
    this.costPoolReplenishmentDetailLogRepository.saveBatch(detailLogList);
  }

  /**
   * 创建验证
   *
   * @param costPoolReplenishmentDetailLog
   */
  private void createValidate(CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog) {
    Validate.notNull(costPoolReplenishmentDetailLog, "新增时，对象信息不能为空！");
    costPoolReplenishmentDetailLog.setId(null);
    Validate.notNull(costPoolReplenishmentDetailLog.getOperationAmount(), "新增数据时，操作金额（数量）（含正负）不能为空！");
    Validate.notNull(costPoolReplenishmentDetailLog.getOperationCode(), "新增数据时，操作记录编号不能为空！");
    Validate.notNull(costPoolReplenishmentDetailLog.getOperationDateTime(), "新增数据时，操作时间 yyyy-MM-dd HH:mm:ss不能为空！");
    Validate.notNull(costPoolReplenishmentDetailLog.getOperationType(), "新增数据时，操作类型不能为空！");
    Validate.notNull(costPoolReplenishmentDetailLog.getPoolCode(), "新增数据时，费用池编号不能为空！");
    Validate.notNull(costPoolReplenishmentDetailLog.getPoolDetailCode(), "新增数据时，费用池明细编号不能为空！");

  }

  /**
   * 修改验证
   *
   * @param costPoolReplenishmentDetailLog
   */
  private void updateValidate(CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog) {
    Validate.notNull(costPoolReplenishmentDetailLog, "修改时，对象信息不能为空！");
    Validate.notBlank(costPoolReplenishmentDetailLog.getId(), "修改数据时，不能为空！");
    Validate.notNull(costPoolReplenishmentDetailLog.getOperationAmount(), "修改数据时，操作金额（数量）（含正负）不能为空！");
    Validate.notBlank(costPoolReplenishmentDetailLog.getOperationCode(), "修改数据时，操作记录编号不能为空！");
    Validate.notNull(costPoolReplenishmentDetailLog.getOperationDateTime(), "修改数据时，操作时间 yyyy-MM-dd HH:mm:ss不能为空！");
    Validate.notBlank(costPoolReplenishmentDetailLog.getOperationType(), "修改数据时，操作类型不能为空！");
    Validate.notBlank(costPoolReplenishmentDetailLog.getPoolCode(), "修改数据时，费用池编号不能为空！");
    Validate.notBlank(costPoolReplenishmentDetailLog.getPoolDetailCode(), "修改数据时，费用池明细编号不能为空！");

  }
}

