package com.biz.crm.dms.business.costpool.replenishment.local.service.internal;

import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetail;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.service.CostPoolReplenishmentDetailVoService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年09月03日 20:27:00
 */
@Service
public class CostPoolReplenishmentDetailVoServiceImpl implements CostPoolReplenishmentDetailVoService {

  @Autowired
  private CostPoolReplenishmentDetailService costPoolReplenishmentDetailService;
  @Autowired
  private NebulaToolkitService  nebulaToolkitService;

  @Override
  public List<CostPoolReplenishmentDetailVo> findByPoolCodeAndFromCode(String poolCode, String fromCode) {
    List<CostPoolReplenishmentDetail> byPoolCodeAndFromCode = costPoolReplenishmentDetailService.findByPoolCodeAndFromCode(poolCode, fromCode);
    if (CollectionUtils.isEmpty(byPoolCodeAndFromCode)){
      return new ArrayList<>(0);
    }
    return(List<CostPoolReplenishmentDetailVo>) this.nebulaToolkitService.copyCollectionByWhiteList(byPoolCodeAndFromCode,CostPoolReplenishmentDetail.class,CostPoolReplenishmentDetailVo.class, HashSet.class,ArrayList.class);
  }
}
