package com.biz.crm.dms.business.costpool.replenishment.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentFile;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentFileRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentOperationRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.constant.PoolReplenishmentConstant;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOperationDto;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * 货补费用池操作记录表(CostPoolReplenishmentOperation)表服务实现类
 *
 * @author HanJiaJun
 * @since 2021-12-28 15:17:36
 */
@Service("costPoolReplenishmentOperationService")
public class CostPoolReplenishmentOperationServiceImpl implements CostPoolReplenishmentOperationService {

  @Autowired(required = false)
  private CostPoolReplenishmentOperationRepository costPoolReplenishmentOperationRepository;
  @Autowired(required = false)
  private CostPoolReplenishmentFileRepository costPoolReplenishmentFileRepository;
  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  /**
   * 分页查询数据
   *
   * @param pageable                       分页对象
   * @param costPoolReplenishmentOperation 实体对象
   * @return
   */
  @Override
  public Page<CostPoolReplenishmentOperation> findByConditions(Pageable pageable, CostPoolReplenishmentOperation costPoolReplenishmentOperation) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(costPoolReplenishmentOperation)) {
      costPoolReplenishmentOperation = new CostPoolReplenishmentOperation();
    }
    return this.costPoolReplenishmentOperationRepository.findByConditions(pageable, costPoolReplenishmentOperation);
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public CostPoolReplenishmentOperation findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.costPoolReplenishmentOperationRepository.getById(id);
  }

  /**
   * 新增数据
   *
   * @param costPoolReplenishmentOperation 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public CostPoolReplenishmentOperation create(CostPoolReplenishmentOperation costPoolReplenishmentOperation) {
    this.createValidate(costPoolReplenishmentOperation);
    this.costPoolReplenishmentOperationRepository.saveOrUpdate(costPoolReplenishmentOperation);
    //新增附件
    Set<CostPoolReplenishmentFile> costPoolReplenishmentFiles = costPoolReplenishmentOperation.getCostPoolReplenishmentFiles();
    if (!CollectionUtils.isEmpty(costPoolReplenishmentFiles)) {
      costPoolReplenishmentFiles.stream().forEach(costPoolDiscountFile -> {
        costPoolDiscountFile.setPoolCode(costPoolReplenishmentOperation.getPoolCode());
        costPoolDiscountFile.setOperationCode(costPoolReplenishmentOperation.getOperationCode());
        costPoolDiscountFile.setId(null);
      });
      this.costPoolReplenishmentFileRepository.saveBatch(costPoolReplenishmentFiles);
    }
    return costPoolReplenishmentOperation;
  }

  /**
   * 修改新据
   *
   * @param costPoolReplenishmentOperation 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public CostPoolReplenishmentOperation update(CostPoolReplenishmentOperation costPoolReplenishmentOperation) {
    this.updateValidate(costPoolReplenishmentOperation);
    this.costPoolReplenishmentOperationRepository.saveOrUpdate(costPoolReplenishmentOperation);
    return costPoolReplenishmentOperation;
  }

  /**
   * 根据费用池编码集合和时间查询  时间包括等于
   *
   * @param dto 实体对象
   * @return
   */
  @Override
  public List<CostPoolReplenishmentOperation> findByPoolCodesAndDate(CostPoolReplenishmentOperationDto dto) {
    if (Objects.isNull(dto)) {
      return new ArrayList<>(0);
    }
    return this.costPoolReplenishmentOperationRepository.findByPoolCodesAndDate(dto);
  }

  /**
   * 根据费用池编码集合和开始时间 查询 开始时间之前的记录
   *
   * @param dto
   * @return
   */
  @Override
  public List<CostPoolReplenishmentOperation> findByPoolCodesAndBeforeDate(CostPoolReplenishmentOperationDto dto) {
    if (Objects.isNull(dto)) {
      return new ArrayList<>(0);
    }
    return this.costPoolReplenishmentOperationRepository.findByPoolCodesAndBeforeDate(dto);
  }

  /**
   * 创建验证
   *
   * @param costPoolReplenishmentOperation
   */
  private void createValidate(CostPoolReplenishmentOperation costPoolReplenishmentOperation) {
    Validate.notNull(costPoolReplenishmentOperation, "新增时，对象信息不能为空！");
    costPoolReplenishmentOperation.setId(null);
    String ruleCode = StringUtils.join(PoolReplenishmentConstant.DISCOUNT_POOL_OPERATION, DateFormatUtils.format(new Date(), "yyyyMMdd"));
    String code = this.generateCodeService.generateCode(ruleCode, 1, 5, 2, TimeUnit.DAYS).get(0);
    costPoolReplenishmentOperation.setOperationCode(code);
    Validate.notNull(costPoolReplenishmentOperation.getOperationAmount(), "新增数据时，操作金额（数量）（含正负）不能为空！");
    Validate.notNull(costPoolReplenishmentOperation.getOperationDateTime(), "新增数据时，操作时间 yyyy-MM-dd HH:mm:ss不能为空！");
    Validate.notNull(costPoolReplenishmentOperation.getOperationType(), "新增数据时，操作类型不能为空！");
    Validate.notNull(costPoolReplenishmentOperation.getPoolCode(), "新增数据时，费用池编号不能为空！");
    // 流水顺序由调用时间来区分
    costPoolReplenishmentOperation.setCreateTime(new Date());
    costPoolReplenishmentOperation.setOperationDateTime(new Date());
  }

  /**
   * 修改验证
   *
   * @param costPoolReplenishmentOperation
   */
  private void updateValidate(CostPoolReplenishmentOperation costPoolReplenishmentOperation) {
    Validate.notNull(costPoolReplenishmentOperation, "修改时，对象信息不能为空！");
    Validate.notBlank(costPoolReplenishmentOperation.getId(), "修改数据时，不能为空！");
    Validate.notNull(costPoolReplenishmentOperation.getOperationAmount(), "修改数据时，操作金额（数量）（含正负）不能为空！");
    Validate.notBlank(costPoolReplenishmentOperation.getOperationCode(), "修改数据时，操作记录编号不能为空！");
    Validate.notNull(costPoolReplenishmentOperation.getOperationDateTime(), "修改数据时，操作时间 yyyy-MM-dd HH:mm:ss不能为空！");
    Validate.notBlank(costPoolReplenishmentOperation.getOperationType(), "修改数据时，操作类型不能为空！");
    Validate.notBlank(costPoolReplenishmentOperation.getPoolCode(), "修改数据时，费用池编号不能为空！");

  }
}

