package com.biz.crm.dms.business.costpool.replenishment.local.service.strategy;

import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetail;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetailLog;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentFile;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailLogService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentFileDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.strategy.OperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author HanJiaJun
 * @describe: 货补费用池，冻结操作类型组实现类
 * @createTime 2021年12月29日 16:18:00
 */
@Component
public class ReplenishmentFreezeOperationTypeStrategyImpl implements OperationTypeStrategy {

  @Autowired(required = false)
  private CostPoolReplenishmentService costPoolReplenishmentService;
  @Autowired(required = false)
  private CostPoolReplenishmentDetailService costPoolReplenishmentDetailService;
  @Autowired(required = false)
  private CostPoolReplenishmentOperationService costPoolReplenishmentOperationService;
  @Autowired(required = false)
  private CostPoolReplenishmentDetailLogService costPoolReplenishmentDetailLogService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getOperationTypeGroup() {
    return PoolOperationTypeGroupEnum.FREEZE.getValue();
  }

  @Override
  @Transactional
  public void onSaveDiscountInfos(CostPoolReplenishmentDto costPoolReplenishmentDto) {
    /**
     * 1、修改费用池数据
     * 2、创建操作记录
     * 3、修改费用池明细数据，创建明细记录
     */
    Validate.notNull(costPoolReplenishmentDto.getPoolCode(), "进行冻结时，费用池编码必传！");
    Date date = new Date();
    BigDecimal amount = costPoolReplenishmentDto.getAmount();
    CostPoolReplenishment poolReplenishment = this.costPoolReplenishmentService.findByPoolCode(costPoolReplenishmentDto.getPoolCode());
    Validate.notNull(poolReplenishment, "进行冻结时未查询到信息");
    //1、======
    poolReplenishment.setUsableAmount(poolReplenishment.getUsableAmount().subtract(amount));
    poolReplenishment.setFreezeAmount(poolReplenishment.getFreezeAmount().add(amount));
    this.costPoolReplenishmentService.update(poolReplenishment);
    //2、======
    CostPoolReplenishmentOperation costPoolReplenishmentOperation = new CostPoolReplenishmentOperation();
    costPoolReplenishmentOperation.setPoolCode(poolReplenishment.getPoolCode());
    costPoolReplenishmentOperation.setOperationType(costPoolReplenishmentDto.getOperationType());
    costPoolReplenishmentOperation.setFromCode(costPoolReplenishmentDto.getFromCode());
    costPoolReplenishmentOperation.setFromDesc(costPoolReplenishmentDto.getFromDesc());
    costPoolReplenishmentOperation.setOperationDateTime(date);
    costPoolReplenishmentOperation.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.FREEZE.getUsableAmountWeight()));
    Set<CostPoolReplenishmentFileDto> costPoolDiscountFiles = costPoolReplenishmentDto.getCostPoolReplenishmentFileDtos();
    if (!CollectionUtils.isEmpty(costPoolDiscountFiles)) {
      Set<CostPoolReplenishmentFile> files = (Set<CostPoolReplenishmentFile>) this.nebulaToolkitService.copyCollectionByWhiteList(costPoolDiscountFiles, CostPoolReplenishmentFileDto.class, CostPoolReplenishmentFile.class, HashSet.class, ArrayList.class);
      costPoolReplenishmentOperation.setCostPoolReplenishmentFiles(files);
    }
    costPoolReplenishmentOperationService.create(costPoolReplenishmentOperation);
    //3、======
    List<CostPoolReplenishmentDetail> replenishmentDetailList = new ArrayList<>();
    List<CostPoolReplenishmentDetailLog> detailLogList = new ArrayList<>();
    List<CostPoolReplenishmentDetail> costPoolReplenishmentDetails = this.costPoolReplenishmentDetailService.findByPoolCode(poolReplenishment.getPoolCode());
    for (CostPoolReplenishmentDetail costPoolReplenishmentDetail : costPoolReplenishmentDetails) {
      if (amount.compareTo(BigDecimal.ZERO) <= 0) {
        break;
      }
      if (costPoolReplenishmentDetail.getUsableAmount().compareTo(BigDecimal.ZERO) > 0) {
        BigDecimal itemUse = BigDecimal.ZERO;
        if (costPoolReplenishmentDetail.getUsableAmount().compareTo(amount) >= 0) {
          itemUse = amount;
        } else {
          itemUse = costPoolReplenishmentDetail.getUsableAmount();
        }
        amount = amount.subtract(itemUse);
        Validate.isTrue(costPoolReplenishmentDetail.getUsableAmount().compareTo(itemUse) >= 0, "冻结时金额不能超过可用金额");
        costPoolReplenishmentDetail.setUsableAmount(costPoolReplenishmentDetail.getUsableAmount().subtract(itemUse));
        costPoolReplenishmentDetail.setFreezeAmount(costPoolReplenishmentDetail.getFreezeAmount().add(itemUse));
        replenishmentDetailList.add(costPoolReplenishmentDetail);
        //组装明细日志数据
        CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog = this.nebulaToolkitService.copyObjectByBlankList(costPoolReplenishmentDetail, CostPoolReplenishmentDetailLog.class, HashSet.class, ArrayList.class, "id");
        costPoolReplenishmentDetailLog.setOperationDateTime(date);
        costPoolReplenishmentDetailLog.setOperationCode(costPoolReplenishmentOperation.getOperationCode());
        costPoolReplenishmentDetailLog.setOperationType(costPoolReplenishmentDto.getOperationType());
        costPoolReplenishmentDetailLog.setFromCode(costPoolReplenishmentDto.getFromCode());
        costPoolReplenishmentDetailLog.setFromDesc(costPoolReplenishmentDto.getFromDesc());
        costPoolReplenishmentDetailLog.setOperationAmount(itemUse.multiply(PoolOperationTypeGroupEnum.FREEZE.getUsableAmountWeight()));
        detailLogList.add(costPoolReplenishmentDetailLog);
      }
    }
    Validate.isTrue(amount.compareTo(BigDecimal.ZERO) == 0, "费用池冻结异常");
    this.costPoolReplenishmentDetailService.updateBatch(replenishmentDetailList);
    this.costPoolReplenishmentDetailLogService.createBatch(detailLogList);
  }
}
