package com.biz.crm.dms.business.costpool.replenishment.local.service.strategy;

import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetail;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetailLog;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentFile;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailLogService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentFileDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.strategy.OperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 货补费用池，占用使用操作类型组实现类
 *
 * @author pengxi
 * @date 2022/6/21
 */
@Component
public class ReplenishmentOccupyUseOperationTypeStrategyImpl implements OperationTypeStrategy {

  @Autowired(required = false)
  private CostPoolReplenishmentService costPoolReplenishmentService;
  @Autowired(required = false)
  private CostPoolReplenishmentDetailService costPoolReplenishmentDetailService;
  @Autowired(required = false)
  private CostPoolReplenishmentOperationService costPoolReplenishmentOperationService;
  @Autowired(required = false)
  private CostPoolReplenishmentDetailLogService costPoolReplenishmentDetailLogService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getOperationTypeGroup() {
    return PoolOperationTypeGroupEnum.OCCUPY_USE.getValue();
  }

  @Override
  @Transactional
  public void onSaveDiscountInfos(CostPoolReplenishmentDto costPoolReplenishmentDto) {
    /**
     * 1、修改费用池数据
     * 2、创建操作记录
     * 3、修改费用池明细数据，创建明细记录
     */
    Validate.notNull(costPoolReplenishmentDto.getPoolCode(), "进行占用使用时，费用池编码必传！");
    Validate.notNull(costPoolReplenishmentDto.getFromCode(), "进行占用使用时，来源编码必传！");
    Validate.notNull(costPoolReplenishmentDto.getFromDesc(), "进行占用使用时，来源描述必传！");
    Date date = new Date();
    BigDecimal amount = costPoolReplenishmentDto.getAmount();
    CostPoolReplenishment poolReplenishment = this.costPoolReplenishmentService.findByPoolCode(costPoolReplenishmentDto.getPoolCode());
    Validate.notNull(poolReplenishment, "进行占用使用时未查询到信息");
    //1、======
    poolReplenishment.setOccupyAmount(poolReplenishment.getOccupyAmount().add(amount));
    poolReplenishment.setUsableAmount(poolReplenishment.getUsableAmount().subtract(amount));
    this.costPoolReplenishmentService.update(poolReplenishment);
    //2、======
    CostPoolReplenishmentOperation costPoolReplenishmentOperation = new CostPoolReplenishmentOperation();
    costPoolReplenishmentOperation.setPoolCode(poolReplenishment.getPoolCode());
    costPoolReplenishmentOperation.setOperationType(costPoolReplenishmentDto.getOperationType());
    costPoolReplenishmentOperation.setFromCode(costPoolReplenishmentDto.getFromCode());
    costPoolReplenishmentOperation.setFromDesc(costPoolReplenishmentDto.getFromDesc());
    costPoolReplenishmentOperation.setOperationDateTime(date);
    costPoolReplenishmentOperation.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.OCCUPY_USE.getUsableAmountWeight()));
    Set<CostPoolReplenishmentFileDto> costPoolDiscountFiles = costPoolReplenishmentDto.getCostPoolReplenishmentFileDtos();
    if (!CollectionUtils.isEmpty(costPoolDiscountFiles)) {
      Set<CostPoolReplenishmentFile> files = (Set<CostPoolReplenishmentFile>) this.nebulaToolkitService.copyCollectionByWhiteList(costPoolDiscountFiles, CostPoolReplenishmentFileDto.class, CostPoolReplenishmentFile.class, HashSet.class, ArrayList.class);
      costPoolReplenishmentOperation.setCostPoolReplenishmentFiles(files);
    }
    costPoolReplenishmentOperationService.create(costPoolReplenishmentOperation);
    //3、======
    List<CostPoolReplenishmentDetail> replenishmentDetailList = new ArrayList<>();
    List<CostPoolReplenishmentDetailLog> detailLogList = new ArrayList<>();
    List<CostPoolReplenishmentDetail> costPoolReplenishmentDetails = this.costPoolReplenishmentDetailService.findByPoolCode(poolReplenishment.getPoolCode());
    for (CostPoolReplenishmentDetail costPoolReplenishmentDetail : costPoolReplenishmentDetails) {
      if (amount.compareTo(BigDecimal.ZERO) <= 0) {
        break;
      }
      if (costPoolReplenishmentDetail.getUsableAmount().compareTo(BigDecimal.ZERO) > 0) {
        BigDecimal itemUse = BigDecimal.ZERO;
        if (costPoolReplenishmentDetail.getUsableAmount().compareTo(amount) >= 0) {
          itemUse = amount;
        } else {
          itemUse = costPoolReplenishmentDetail.getUsableAmount();
        }
        amount = amount.subtract(itemUse);
        Validate.isTrue(costPoolReplenishmentDetail.getUsableAmount().compareTo(itemUse) >= 0, "占用使用时金额不能超过可用金额");
        costPoolReplenishmentDetail.setOccupyAmount(costPoolReplenishmentDetail.getOccupyAmount().add(itemUse));
        costPoolReplenishmentDetail.setUsableAmount(costPoolReplenishmentDetail.getUsableAmount().subtract(itemUse));
        // 标记最初占用哪个，等后面审批通过时才能找到对应的做释放
        costPoolReplenishmentDetail.setFromCode(costPoolReplenishmentDto.getFromCode());
        costPoolReplenishmentDetail.setFromDesc(costPoolReplenishmentDto.getFromDesc());
        replenishmentDetailList.add(costPoolReplenishmentDetail);
        //组装明细日志数据
        CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog = this.nebulaToolkitService.copyObjectByBlankList(costPoolReplenishmentDetail, CostPoolReplenishmentDetailLog.class, HashSet.class, ArrayList.class, "id");
        costPoolReplenishmentDetailLog.setOperationDateTime(date);
        costPoolReplenishmentDetailLog.setOperationCode(costPoolReplenishmentOperation.getOperationCode());
        costPoolReplenishmentDetailLog.setOperationType(costPoolReplenishmentDto.getOperationType());
        costPoolReplenishmentDetailLog.setFromCode(costPoolReplenishmentDto.getFromCode());
        costPoolReplenishmentDetailLog.setFromDesc(costPoolReplenishmentDto.getFromDesc());
        costPoolReplenishmentDetailLog.setOperationAmount(itemUse.multiply(PoolOperationTypeGroupEnum.OCCUPY_USE.getUsableAmountWeight()));
        detailLogList.add(costPoolReplenishmentDetailLog);
      }
    }
    Validate.isTrue(amount.compareTo(BigDecimal.ZERO) == 0, "费用池占用使用异常");
    this.costPoolReplenishmentDetailService.updateBatch(replenishmentDetailList);
    this.costPoolReplenishmentDetailLogService.createBatch(detailLogList);
  }
}
