/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.replenishment.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetail;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentProduct;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentDetailRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentProductService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.strategy.DetailOperationTypeStrategy;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="costPoolReplenishmentDetailService")
public class CostPoolReplenishmentDetailServiceImpl
implements CostPoolReplenishmentDetailService {
    @Autowired(required=false)
    private CostPoolReplenishmentDetailRepository costPoolReplenishmentDetailRepository;
    @Autowired(required=false)
    private List<DetailOperationTypeStrategy> detailOperationTypeStrategies;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private CostPoolReplenishmentService costPoolReplenishmentService;
    @Autowired(required=false)
    private CostPoolReplenishmentProductService costPoolReplenishmentProductService;

    @Override
    public Page<CostPoolReplenishmentDetail> findByConditions(Pageable pageable, CostPoolReplenishmentDetail costPoolReplenishmentDetail) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)costPoolReplenishmentDetail)) {
            costPoolReplenishmentDetail = new CostPoolReplenishmentDetail();
        }
        costPoolReplenishmentDetail.setTenantCode(TenantUtils.getTenantCode());
        return this.costPoolReplenishmentDetailRepository.findByConditions(pageable, costPoolReplenishmentDetail);
    }

    @Override
    public CostPoolReplenishmentDetail findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return new CostPoolReplenishmentDetail();
        }
        CostPoolReplenishmentDetail costPoolReplenishmentDetail = (CostPoolReplenishmentDetail)((Object)this.costPoolReplenishmentDetailRepository.getById((Serializable)((Object)id)));
        if (Objects.isNull((Object)costPoolReplenishmentDetail)) {
            return new CostPoolReplenishmentDetail();
        }
        CostPoolReplenishment costPoolReplenishment = this.costPoolReplenishmentService.findByPoolCode(costPoolReplenishmentDetail.getPoolCode());
        ArrayList<CostPoolReplenishment> list = new ArrayList<CostPoolReplenishment>();
        list.add(costPoolReplenishment);
        List<CostPoolReplenishment> costPoolReplenishments = this.splicingProduct(list);
        if (CollectionUtils.isEmpty(costPoolReplenishments)) {
            return costPoolReplenishmentDetail;
        }
        costPoolReplenishmentDetail.setCostPoolReplenishment(costPoolReplenishments.get(0));
        return costPoolReplenishmentDetail;
    }

    private List<CostPoolReplenishment> splicingProduct(List<CostPoolReplenishment> records) {
        List<String> codes = records.stream().map(CostPoolReplenishment::getPoolCode).collect(Collectors.toList());
        List<CostPoolReplenishmentProduct> products = this.costPoolReplenishmentProductService.findByPoolCodes(codes);
        if (CollectionUtils.isEmpty(products)) {
            return records;
        }
        Map<String, List<CostPoolReplenishmentProduct>> productMap = products.stream().collect(Collectors.groupingBy(CostPoolReplenishmentProduct::getPoolCode));
        if (CollectionUtils.isEmpty(productMap)) {
            return records;
        }
        for (CostPoolReplenishment record : records) {
            List<CostPoolReplenishmentProduct> product = productMap.get(record.getPoolCode());
            record.setCostPoolReplenishmentProduct(product);
        }
        return records;
    }

    @Override
    @Transactional
    public CostPoolReplenishmentDetail create(CostPoolReplenishmentDetail costPoolReplenishmentDetail) {
        this.createForm(costPoolReplenishmentDetail);
        this.createValidate(costPoolReplenishmentDetail);
        this.costPoolReplenishmentDetailRepository.saveOrUpdate((Object)costPoolReplenishmentDetail);
        return costPoolReplenishmentDetail;
    }

    @Override
    @Transactional
    public CostPoolReplenishmentDetail update(CostPoolReplenishmentDetail costPoolReplenishmentDetail) {
        this.updateValidate(costPoolReplenishmentDetail);
        this.updateForm(costPoolReplenishmentDetail);
        this.costPoolReplenishmentDetailRepository.saveOrUpdate((Object)costPoolReplenishmentDetail);
        return costPoolReplenishmentDetail;
    }

    @Override
    public void createBatch(List<CostPoolReplenishmentDetail> replenishmentDetailList) {
        if (CollectionUtils.isEmpty(replenishmentDetailList)) {
            return;
        }
        replenishmentDetailList.forEach(e -> {
            this.createForm((CostPoolReplenishmentDetail)((Object)e));
            this.createValidate((CostPoolReplenishmentDetail)((Object)e));
        });
        this.costPoolReplenishmentDetailRepository.saveBatch(replenishmentDetailList);
    }

    @Override
    @Transactional
    public void updateBatch(List<CostPoolReplenishmentDetail> replenishmentDetailList) {
        if (CollectionUtils.isEmpty(replenishmentDetailList)) {
            return;
        }
        this.costPoolReplenishmentDetailRepository.updateBatchById(replenishmentDetailList);
    }

    @Override
    public List<CostPoolReplenishmentDetail> findByPoolCode(String poolCode) {
        if (StringUtils.isBlank((CharSequence)poolCode)) {
            return new ArrayList<CostPoolReplenishmentDetail>(0);
        }
        return this.costPoolReplenishmentDetailRepository.findByPoolCode(poolCode);
    }

    @Override
    public List<CostPoolReplenishmentDetail> findByPoolCodeAndFromCode(String poolCode, String fromCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{poolCode, fromCode})) {
            return new ArrayList<CostPoolReplenishmentDetail>(0);
        }
        return this.costPoolReplenishmentDetailRepository.findByPoolCodeAndFromCode(poolCode, fromCode);
    }

    @Override
    @Transactional
    public void handleAdjust(CostPoolReplenishmentDto costPoolReplenishmentDto) {
        this.handleAdjustValidate(costPoolReplenishmentDto);
        PoolOperationTypeEnum operationTypeEnum = PoolOperationTypeEnum.getByKey((String)costPoolReplenishmentDto.getOperationType());
        Validate.notNull((Object)operationTypeEnum, (String)"\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c\u7c7b\u578b\u8fdb\u884c\u8c03\u6574\u8d39\u7528\u6c60\u4fe1\u606f", (Object[])new Object[0]);
        String operationTypeGroup = operationTypeEnum.getGroup();
        Validate.isTrue((!CollectionUtils.isEmpty(this.detailOperationTypeStrategies) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u64cd\u4f5c\u7c7b\u578b\u5bf9\u5e94\u7684\u7b56\u7565\u5b9e\u73b0", (Object[])new Object[0]);
        for (DetailOperationTypeStrategy operationTypeStrategy : this.detailOperationTypeStrategies) {
            String group = operationTypeStrategy.getOperationTypeGroup();
            if (!StringUtils.equals((CharSequence)group, (CharSequence)operationTypeGroup)) continue;
            operationTypeStrategy.onSaveDiscountInfos(costPoolReplenishmentDto);
            break;
        }
    }

    @Override
    public CostPoolReplenishmentDetail findByPoolDetailCode(String poolDetailCode) {
        if (StringUtils.isBlank((CharSequence)poolDetailCode)) {
            return null;
        }
        return this.costPoolReplenishmentDetailRepository.findByPoolDetailCode(poolDetailCode);
    }

    private void createValidate(CostPoolReplenishmentDetail costPoolReplenishmentDetail) {
        Validate.notNull((Object)((Object)costPoolReplenishmentDetail), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        costPoolReplenishmentDetail.setId(null);
        Validate.notBlank((CharSequence)costPoolReplenishmentDetail.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDetail.getAccountDateTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e0a\u8d26\u65f6\u95f4 yyyy-MM-dd HH:mm:ss\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDetail.getFreezeAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u51bb\u7ed3\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDetail.getHasUseAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5df2\u4f7f\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDetail.getOccupyAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5360\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentDetail.getOperationCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u8bb0\u5f55\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentDetail.getOperationType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentDetail.getPoolCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentDetail.getPoolDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDetail.getTotalAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u603b\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDetail.getUsableAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5269\u4f59\u53ef\u4f7f\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(CostPoolReplenishmentDetail costPoolReplenishmentDetail) {
        Validate.notNull((Object)((Object)costPoolReplenishmentDetail), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentDetail.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentDetail.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDetail.getAccountDateTime(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0a\u8d26\u65f6\u95f4 yyyy-MM-dd HH:mm:ss\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDetail.getFreezeAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u51bb\u7ed3\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDetail.getHasUseAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5df2\u4f7f\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDetail.getOccupyAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5360\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentDetail.getOperationCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u8bb0\u5f55\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentDetail.getOperationType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentDetail.getPoolCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentDetail.getPoolDetailCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDetail.getTotalAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u603b\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDetail.getUsableAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5269\u4f59\u53ef\u4f7f\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void handleAdjustValidate(CostPoolReplenishmentDto costPoolReplenishmentDto) {
        Validate.notNull((Object)costPoolReplenishmentDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentDto.getCustomerCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDto.getAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((costPoolReplenishmentDto.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        List byCustomerCodes = this.customerVoService.findByCustomerCodes((List)Lists.newArrayList((Object[])new String[]{costPoolReplenishmentDto.getCustomerCode()}));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)byCustomerCodes) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        costPoolReplenishmentDto.setCustomerName(((CustomerVo)byCustomerCodes.get(0)).getCustomerName());
        Validate.notBlank((CharSequence)costPoolReplenishmentDto.getCustomerName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateForm(CostPoolReplenishmentDetail costPoolReplenishmentDetail) {
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        costPoolReplenishmentDetail.setModifyAccount(loginUser.getAccount());
        costPoolReplenishmentDetail.setModifyName(loginUser.getUsername());
        costPoolReplenishmentDetail.setModifyTime(new Date());
    }

    private void createForm(CostPoolReplenishmentDetail costPoolReplenishmentDetail) {
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        Date date = new Date();
        costPoolReplenishmentDetail.setId(null);
        String ruleCode = StringUtils.join((Object[])new String[]{"HBMX", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        String code = (String)this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        costPoolReplenishmentDetail.setPoolDetailCode(code);
        costPoolReplenishmentDetail.setCreateAccount(loginUser.getAccount());
        costPoolReplenishmentDetail.setCreateName(loginUser.getUsername());
        costPoolReplenishmentDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        costPoolReplenishmentDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        costPoolReplenishmentDetail.setCreateTime(date);
        costPoolReplenishmentDetail.setModifyAccount(loginUser.getAccount());
        costPoolReplenishmentDetail.setModifyName(loginUser.getUsername());
        costPoolReplenishmentDetail.setModifyTime(date);
        costPoolReplenishmentDetail.setTenantCode(TenantUtils.getTenantCode());
    }
}

