/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.replenishment.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentFile;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentFileRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentOperationRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOperationDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="costPoolReplenishmentOperationService")
public class CostPoolReplenishmentOperationServiceImpl
implements CostPoolReplenishmentOperationService {
    @Autowired(required=false)
    private CostPoolReplenishmentOperationRepository costPoolReplenishmentOperationRepository;
    @Autowired(required=false)
    private CostPoolReplenishmentFileRepository costPoolReplenishmentFileRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    @Override
    public Page<CostPoolReplenishmentOperation> findByConditions(Pageable pageable, CostPoolReplenishmentOperation costPoolReplenishmentOperation) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)costPoolReplenishmentOperation)) {
            costPoolReplenishmentOperation = new CostPoolReplenishmentOperation();
        }
        return this.costPoolReplenishmentOperationRepository.findByConditions(pageable, costPoolReplenishmentOperation);
    }

    @Override
    public CostPoolReplenishmentOperation findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (CostPoolReplenishmentOperation)((Object)this.costPoolReplenishmentOperationRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public CostPoolReplenishmentOperation create(CostPoolReplenishmentOperation costPoolReplenishmentOperation) {
        this.createValidate(costPoolReplenishmentOperation);
        this.costPoolReplenishmentOperationRepository.saveOrUpdate((Object)costPoolReplenishmentOperation);
        Set<CostPoolReplenishmentFile> costPoolReplenishmentFiles = costPoolReplenishmentOperation.getCostPoolReplenishmentFiles();
        if (!CollectionUtils.isEmpty(costPoolReplenishmentFiles)) {
            costPoolReplenishmentFiles.stream().forEach(costPoolDiscountFile -> {
                costPoolDiscountFile.setPoolCode(costPoolReplenishmentOperation.getPoolCode());
                costPoolDiscountFile.setOperationCode(costPoolReplenishmentOperation.getOperationCode());
                costPoolDiscountFile.setId(null);
            });
            this.costPoolReplenishmentFileRepository.saveBatch(costPoolReplenishmentFiles);
        }
        return costPoolReplenishmentOperation;
    }

    @Override
    @Transactional
    public CostPoolReplenishmentOperation update(CostPoolReplenishmentOperation costPoolReplenishmentOperation) {
        this.updateValidate(costPoolReplenishmentOperation);
        this.costPoolReplenishmentOperationRepository.saveOrUpdate((Object)costPoolReplenishmentOperation);
        return costPoolReplenishmentOperation;
    }

    @Override
    public List<CostPoolReplenishmentOperation> findByPoolCodesAndDate(CostPoolReplenishmentOperationDto dto) {
        if (Objects.isNull(dto)) {
            return new ArrayList<CostPoolReplenishmentOperation>(0);
        }
        return this.costPoolReplenishmentOperationRepository.findByPoolCodesAndDate(dto);
    }

    @Override
    public List<CostPoolReplenishmentOperation> findByPoolCodesAndBeforeDate(CostPoolReplenishmentOperationDto dto) {
        if (Objects.isNull(dto)) {
            return new ArrayList<CostPoolReplenishmentOperation>(0);
        }
        return this.costPoolReplenishmentOperationRepository.findByPoolCodesAndBeforeDate(dto);
    }

    private void createValidate(CostPoolReplenishmentOperation costPoolReplenishmentOperation) {
        Validate.notNull((Object)((Object)costPoolReplenishmentOperation), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        costPoolReplenishmentOperation.setId(null);
        String ruleCode = StringUtils.join((Object[])new String[]{"HBOP", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        String code = (String)this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        costPoolReplenishmentOperation.setOperationCode(code);
        Validate.notNull((Object)costPoolReplenishmentOperation.getOperationAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u91d1\u989d\uff08\u6570\u91cf\uff09\uff08\u542b\u6b63\u8d1f\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentOperation.getOperationDateTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u65f6\u95f4 yyyy-MM-dd HH:mm:ss\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentOperation.getOperationType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentOperation.getPoolCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        costPoolReplenishmentOperation.setCreateTime(new Date());
        costPoolReplenishmentOperation.setOperationDateTime(new Date());
    }

    private void updateValidate(CostPoolReplenishmentOperation costPoolReplenishmentOperation) {
        Validate.notNull((Object)((Object)costPoolReplenishmentOperation), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentOperation.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentOperation.getOperationAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u91d1\u989d\uff08\u6570\u91cf\uff09\uff08\u542b\u6b63\u8d1f\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentOperation.getOperationCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u8bb0\u5f55\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentOperation.getOperationDateTime(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u65f6\u95f4 yyyy-MM-dd HH:mm:ss\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentOperation.getOperationType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentOperation.getPoolCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

