/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.replenishment.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentOperationRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationVoService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOperationDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.CostPoolReplenishmentOperationGroupEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOperationVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="costPoolReplenishmentOperationVoService")
public class CostPoolReplenishmentOperationVoServiceImpl
implements CostPoolReplenishmentOperationVoService {
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private CostPoolReplenishmentRepository costPoolReplenishmentRepository;
    @Autowired(required=false)
    private CostPoolReplenishmentOperationRepository costPoolReplenishmentOperationRepository;

    @Override
    public Page<CostPoolReplenishmentOperationVo> findByCostPoolReplenishmentOperationDto(Pageable pageable, CostPoolReplenishmentOperationDto dto) {
        String customerCode = dto.getCustomerCode();
        Page pageResultEmpty = new Page(0L, 0L, 0L);
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return pageResultEmpty;
        }
        List<CostPoolReplenishment> costPoolReplenishmentList = this.costPoolReplenishmentRepository.findByCustomerCode(customerCode);
        if (CollectionUtils.isEmpty(costPoolReplenishmentList)) {
            return pageResultEmpty;
        }
        dto.setPoolCodeList(costPoolReplenishmentList.stream().map(CostPoolReplenishment::getPoolCode).collect(Collectors.toList()));
        Validate.notBlank((CharSequence)dto.getGroup(), (String)"\u4e0a\u8d26/\u4f7f\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CostPoolReplenishmentOperationGroupEnum groupEnum = CostPoolReplenishmentOperationGroupEnum.getByDictCode((String)dto.getGroup());
        Validate.isTrue((!ObjectUtils.isEmpty((Object)groupEnum) ? 1 : 0) != 0, (String)"\u4e0a\u8d26/\u4f7f\u7528\u6807\u8bc6\u9519\u8bef", (Object[])new Object[0]);
        List operationTypeList = PoolOperationTypeEnum.getDictCodeByGroupEnum((CostPoolReplenishmentOperationGroupEnum)groupEnum);
        dto.setOperationTypeList(operationTypeList);
        pageable = (Pageable)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<CostPoolReplenishmentOperationVo> entityResult = this.costPoolReplenishmentOperationRepository.findByCostPoolReplenishmentOperationDto((Page<CostPoolReplenishmentOperationVo>)page, dto);
        return entityResult;
    }
}

