/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.replenishment.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentProduct;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentOrderVoRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentProductService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOrderPageDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.service.CostPoolReplenishmentOrderVoService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOrderProductVo;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOrderVo;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="costPoolReplenishmentOrderVoServiceImpl")
public class CostPoolReplenishmentOrderVoServiceImpl
implements CostPoolReplenishmentOrderVoService {
    @Autowired(required=false)
    private CostPoolReplenishmentOrderVoRepository costPoolReplenishmentOrderVoRepository;
    @Autowired(required=false)
    private CostPoolReplenishmentProductService costPoolReplenishmentProductService;
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<CostPoolReplenishmentOrderVo> findByReplenishmentPageDto(Pageable pageable, CostPoolReplenishmentOrderPageDto costPoolReplenishmentOrderPageDto) {
        Page<CostPoolReplenishmentOrderVo> byConditions;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(costPoolReplenishmentOrderPageDto)) {
            costPoolReplenishmentOrderPageDto = new CostPoolReplenishmentOrderPageDto();
        }
        if (Objects.isNull(byConditions = this.costPoolReplenishmentOrderVoRepository.findByReplenishmentPageDto(pageable, costPoolReplenishmentOrderPageDto))) {
            return byConditions;
        }
        List records = byConditions.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return byConditions;
        }
        List<CostPoolReplenishmentOrderVo> newRecords = this.splicingProduct(records);
        this.screeningProducts(newRecords, costPoolReplenishmentOrderPageDto);
        for (CostPoolReplenishmentOrderVo vo : newRecords) {
            String poolCode = vo.getPoolCode();
            List costPoolReplenishmentProduct = vo.getCostPoolReplenishmentProduct();
            ArrayList<CostPoolReplenishmentOrderProductVo> list = new ArrayList<CostPoolReplenishmentOrderProductVo>();
            if (!CollectionUtils.isEmpty((Collection)costPoolReplenishmentProduct)) {
                for (CostPoolReplenishmentOrderProductVo v : costPoolReplenishmentProduct) {
                    CostPoolReplenishmentOrderProductVo entity = new CostPoolReplenishmentOrderProductVo();
                    entity = (CostPoolReplenishmentOrderProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)v, CostPoolReplenishmentOrderProductVo.class, HashSet.class, ArrayList.class, new String[0]);
                    entity.setPoolCode(poolCode);
                    list.add(entity);
                }
            }
            vo.setCostPoolReplenishmentProduct(list);
        }
        byConditions.setRecords(newRecords);
        return byConditions;
    }

    private void screeningProducts(List<CostPoolReplenishmentOrderVo> newRecords, CostPoolReplenishmentOrderPageDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getGoodsProductName()) && StringUtils.isBlank((CharSequence)dto.getGoodsProductCode())) {
            return;
        }
        if (CollectionUtils.isEmpty(newRecords)) {
            return;
        }
        for (CostPoolReplenishmentOrderVo newRecord : newRecords) {
            List<Object> newList = new ArrayList();
            List list = newRecord.getCostPoolReplenishmentProduct();
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            if (StringUtils.isNotBlank((CharSequence)dto.getGoodsProductName()) || StringUtils.isNotBlank((CharSequence)dto.getGoodsProductCode())) {
                newList = list.stream().filter(e -> StringUtils.isNotBlank((CharSequence)dto.getGoodsProductName()) ? e.getGoodsProductName().contains(dto.getGoodsProductName()) : true).filter(e -> StringUtils.isNotBlank((CharSequence)dto.getGoodsProductCode()) ? e.getGoodsProductCode().contains(dto.getGoodsProductCode()) : true).collect(Collectors.toList());
            }
            newRecord.setCostPoolReplenishmentProduct(newList);
        }
    }

    private List<CostPoolReplenishmentOrderVo> splicingProduct(List<CostPoolReplenishmentOrderVo> records) {
        List<String> codes = records.stream().map(CostPoolReplenishmentOrderVo::getPoolCode).collect(Collectors.toList());
        List<CostPoolReplenishmentProduct> products = this.costPoolReplenishmentProductService.findByPoolCodes(codes);
        List<String> productCodes = products.stream().map(CostPoolReplenishmentProduct::getGoodsProductCode).collect(Collectors.toList());
        List detailsByIdsOrProductCodes = this.productVoService.findDetailsByIdsOrProductCodes(new ArrayList(0), productCodes);
        Map<String, List<CostPoolReplenishmentProduct>> productMap = products.stream().collect(Collectors.groupingBy(CostPoolReplenishmentProduct::getPoolCode));
        List poolCodes = products.stream().map(CostPoolReplenishmentProduct::getPoolCode).collect(Collectors.toList());
        codes.removeAll(poolCodes);
        ArrayList curAndParentCodes = new ArrayList();
        HashMap<String, List> levelMap = new HashMap<String, List>();
        if (!CollectionUtils.isEmpty(codes)) {
            List levelCodes = records.stream().filter(e -> codes.contains(e.getPoolCode())).map(CostPoolReplenishmentOrderVo::getGoodsProductLevelCode).collect(Collectors.toList());
            for (String levelCode : levelCodes) {
                HashSet set = Sets.newHashSet();
                set.add(levelCode);
                List curAndChildrenCodesByCodes = this.productLevelVoSdkService.findCurAndChildrenCodesByCodes((Set)set);
                levelMap.put(levelCode, curAndChildrenCodesByCodes);
            }
            levelMap.forEach((k, v) -> curAndParentCodes.addAll(v));
        }
        if (!CollectionUtils.isEmpty(curAndParentCodes)) {
            List productVos = this.productVoService.findByProductLevelCodes(curAndParentCodes);
            productCodes.addAll(productVos.stream().map(ProductVo::getProductCode).collect(Collectors.toList()));
        }
        List<CostPoolReplenishmentOrderProductVo> vos = this.supplementProduct(records.get(0).getCustomerCode(), productCodes);
        Map<String, CostPoolReplenishmentOrderProductVo> voMap = vos.stream().collect(Collectors.toMap(CostPoolReplenishmentOrderProductVo::getGoodsProductCode, v -> v));
        for (CostPoolReplenishmentOrderVo record : records) {
            ArrayList<CostPoolReplenishmentOrderProductVo> newProductList = new ArrayList<CostPoolReplenishmentOrderProductVo>();
            String poolCode = record.getPoolCode();
            if (productMap.containsKey(poolCode)) {
                List<CostPoolReplenishmentProduct> list = productMap.get(poolCode);
                for (CostPoolReplenishmentProduct v2 : list) {
                    CostPoolReplenishmentOrderProductVo vo = voMap.get(v2.getGoodsProductCode());
                    if (vo == null) continue;
                    newProductList.add(vo);
                }
                record.setCostPoolReplenishmentProduct(newProductList);
                continue;
            }
            String goodsProductLevelCode = record.getGoodsProductLevelCode();
            List strings = (List)levelMap.get(goodsProductLevelCode);
            if (CollectionUtils.isEmpty((Collection)strings)) continue;
            List collect = vos.stream().filter(e -> strings.contains(e.getProductLevelCode())).collect(Collectors.toList());
            record.setCostPoolReplenishmentProduct(collect);
        }
        return records;
    }

    private List<CostPoolReplenishmentOrderProductVo> supplementProduct(String customerCode, List<String> productCodes) {
        List detailsByIdsOrProductCodes = this.productVoService.findDetailsByIdsOrProductCodes(new ArrayList(0), productCodes);
        FindPriceDto findPriceDto = new FindPriceDto();
        findPriceDto.setDimensionCode(PriceDimensionEnum.PRODUCT.getDictCode());
        findPriceDto.setProductCodeSet((Set)Sets.newHashSet(productCodes));
        findPriceDto.setUserCode(customerCode);
        findPriceDto.setUserType(FindPriceUserTypeEnum.CUSTOMER.getDictCode());
        Map priceModelVoMap = this.priceModelVoService.findPrice(findPriceDto);
        ArrayList<CostPoolReplenishmentOrderProductVo> vos = new ArrayList<CostPoolReplenishmentOrderProductVo>();
        for (ProductVo d : detailsByIdsOrProductCodes) {
            CostPoolReplenishmentOrderProductVo v = new CostPoolReplenishmentOrderProductVo();
            v.setGoodsProductCode(d.getProductCode());
            v.setProductLevelCode(d.getProductLevelCode());
            v.setGoodsProductName(d.getProductName());
            v.setBaseUnit(d.getBaseUnit());
            v.setSpec(d.getSpec());
            v.setSaleUnit(d.getSaleUnit());
            v.setId(d.getId());
            vos.add(v);
        }
        vos.forEach(e -> {
            String goodsProductCode = e.getGoodsProductCode();
            if (priceModelVoMap.containsKey(goodsProductCode)) {
                BigDecimal price = ((PriceModelVo)priceModelVoMap.get(goodsProductCode)).getPrice();
                e.setPrice(price);
            }
        });
        if (CollectionUtils.isEmpty(vos)) {
            return new ArrayList<CostPoolReplenishmentOrderProductVo>(0);
        }
        return vos;
    }
}

