/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.replenishment.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentProduct;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentProductService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentProductDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolGroupEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolPayTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolUseTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.strategy.OperationTypeStrategy;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="costPoolReplenishmentService")
public class CostPoolReplenishmentServiceImpl
implements CostPoolReplenishmentService {
    @Autowired(required=false)
    private CostPoolReplenishmentRepository costPoolReplenishmentRepository;
    @Autowired(required=false)
    private List<OperationTypeStrategy> operationTypeStrategies;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private CostPoolReplenishmentProductService costPoolReplenishmentProductService;

    @Override
    public Page<CostPoolReplenishment> findByConditions(Pageable pageable, CostPoolReplenishmentDto costPoolReplenishmentDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(costPoolReplenishmentDto)) {
            costPoolReplenishmentDto = new CostPoolReplenishmentDto();
        }
        Page<CostPoolReplenishment> byConditions = this.costPoolReplenishmentRepository.findByConditions(pageable, costPoolReplenishmentDto);
        return byConditions;
    }

    private List<CostPoolReplenishment> splicingProduct(List<CostPoolReplenishment> records) {
        List<String> codes = records.stream().map(CostPoolReplenishment::getPoolCode).collect(Collectors.toList());
        List<CostPoolReplenishmentProduct> products = this.costPoolReplenishmentProductService.findByPoolCodes(codes);
        if (CollectionUtils.isEmpty(products)) {
            return records;
        }
        Map<String, List<CostPoolReplenishmentProduct>> productMap = products.stream().collect(Collectors.groupingBy(CostPoolReplenishmentProduct::getPoolCode));
        if (CollectionUtils.isEmpty(productMap)) {
            return records;
        }
        for (CostPoolReplenishment record : records) {
            List<CostPoolReplenishmentProduct> product = productMap.get(record.getPoolCode());
            record.setCostPoolReplenishmentProduct(product);
        }
        return records;
    }

    @Override
    public CostPoolReplenishment findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        CostPoolReplenishment costPoolReplenishment = (CostPoolReplenishment)((Object)this.costPoolReplenishmentRepository.getById((Serializable)((Object)id)));
        if (Objects.isNull((Object)costPoolReplenishment)) {
            return null;
        }
        ArrayList<CostPoolReplenishment> list = new ArrayList<CostPoolReplenishment>();
        list.add(costPoolReplenishment);
        List<CostPoolReplenishment> costPoolReplenishments = this.splicingProduct(list);
        if (CollectionUtils.isEmpty(costPoolReplenishments)) {
            return null;
        }
        return costPoolReplenishments.get(0);
    }

    @Override
    @Transactional
    public CostPoolReplenishment create(CostPoolReplenishment costPoolReplenishment) {
        this.createForm(costPoolReplenishment);
        this.createValidate(costPoolReplenishment);
        this.costPoolReplenishmentRepository.saveOrUpdate((Object)costPoolReplenishment);
        List<CostPoolReplenishmentProduct> costPoolReplenishmentProduct = costPoolReplenishment.getCostPoolReplenishmentProduct();
        if (CollectionUtils.isEmpty(costPoolReplenishmentProduct)) {
            return costPoolReplenishment;
        }
        for (CostPoolReplenishmentProduct poolReplenishmentProduct : costPoolReplenishmentProduct) {
            poolReplenishmentProduct.setPoolCode(costPoolReplenishment.getPoolCode());
            poolReplenishmentProduct.setProductLevelCode(costPoolReplenishment.getGoodsProductLevelCode());
        }
        this.costPoolReplenishmentProductService.create(costPoolReplenishmentProduct);
        return costPoolReplenishment;
    }

    @Override
    @Transactional
    public CostPoolReplenishment update(CostPoolReplenishment costPoolReplenishment) {
        this.updateValidate(costPoolReplenishment);
        this.updateForm(costPoolReplenishment);
        this.costPoolReplenishmentRepository.saveOrUpdate((Object)costPoolReplenishment);
        return costPoolReplenishment;
    }

    @Override
    public CostPoolReplenishment findByCostPoolReplenishmentDto(CostPoolReplenishmentDto costPoolReplenishmentDto) {
        CostPoolReplenishment poolReplenishment;
        if (costPoolReplenishmentDto == null) {
            return null;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{costPoolReplenishmentDto.getCustomerCode(), costPoolReplenishmentDto.getGoodsProductLevelCode(), costPoolReplenishmentDto.getUseType()})) {
            return null;
        }
        List<CostPoolReplenishment> costPoolReplenishmentList = this.costPoolReplenishmentRepository.findByCostPoolReplenishmentDto(costPoolReplenishmentDto);
        if (CollectionUtils.isEmpty(costPoolReplenishmentList)) {
            return null;
        }
        List poolReplenishmentProduct = costPoolReplenishmentDto.getCostPoolReplenishmentProduct();
        List<String> dtoCodes = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)poolReplenishmentProduct)) {
            dtoCodes = poolReplenishmentProduct.stream().map(CostPoolReplenishmentProductDto::getGoodsProductCode).collect(Collectors.toList());
        }
        if ((poolReplenishment = this.validateProductList(dtoCodes, costPoolReplenishmentList)) == null) {
            return null;
        }
        return poolReplenishment;
    }

    private CostPoolReplenishment validateProductList(List<String> dtoCodes, List<CostPoolReplenishment> costPoolReplenishmentList) {
        for (CostPoolReplenishment poolReplenishment : costPoolReplenishmentList) {
            List<CostPoolReplenishmentProduct> costPoolReplenishmentProduct = poolReplenishment.getCostPoolReplenishmentProduct();
            List<Object> codes = new ArrayList();
            if (!CollectionUtils.isEmpty(costPoolReplenishmentProduct)) {
                codes = costPoolReplenishmentProduct.stream().map(CostPoolReplenishmentProduct::getGoodsProductCode).collect(Collectors.toList());
            }
            if (codes.size() == 0 && dtoCodes.size() == 0) {
                return poolReplenishment;
            }
            if (codes.size() != dtoCodes.size() || !codes.containsAll(dtoCodes)) continue;
            return poolReplenishment;
        }
        return null;
    }

    @Override
    @Transactional
    public void handleAdjust(CostPoolReplenishmentDto costPoolReplenishmentDto) {
        this.handleAdjustValidate(costPoolReplenishmentDto);
        PoolOperationTypeEnum operationTypeEnum = PoolOperationTypeEnum.getByKey((String)costPoolReplenishmentDto.getOperationType());
        Validate.notNull((Object)operationTypeEnum, (String)"\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c\u7c7b\u578b\u8fdb\u884c\u8c03\u6574\u8d39\u7528\u6c60\u4fe1\u606f", (Object[])new Object[0]);
        String operationTypeGroup = operationTypeEnum.getGroup();
        Validate.isTrue((!CollectionUtils.isEmpty(this.operationTypeStrategies) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u64cd\u4f5c\u7c7b\u578b\u5bf9\u5e94\u7684\u7b56\u7565\u5b9e\u73b0", (Object[])new Object[0]);
        for (OperationTypeStrategy operationTypeStrategy : this.operationTypeStrategies) {
            String group = operationTypeStrategy.getOperationTypeGroup();
            if (!StringUtils.equals((CharSequence)group, (CharSequence)operationTypeGroup)) continue;
            operationTypeStrategy.onSaveDiscountInfos(costPoolReplenishmentDto);
            break;
        }
    }

    @Override
    public CostPoolReplenishment findByPoolCode(String poolCode) {
        if (StringUtils.isBlank((CharSequence)poolCode)) {
            return null;
        }
        return this.costPoolReplenishmentRepository.findByPoolCode(poolCode);
    }

    @Override
    public List<CostPoolReplenishment> findByPoolCodesAndCustomerCode(List<String> poolCodes, String customerCode) {
        if (CollectionUtils.isEmpty(poolCodes)) {
            return new ArrayList<CostPoolReplenishment>(0);
        }
        List<CostPoolReplenishment> byPoolCodesAndCustomerCode = this.costPoolReplenishmentRepository.findByPoolCodesAndCustomerCode(poolCodes, customerCode);
        if (CollectionUtils.isEmpty(byPoolCodesAndCustomerCode)) {
            return new ArrayList<CostPoolReplenishment>(0);
        }
        List<CostPoolReplenishment> costPoolReplenishments = this.splicingProduct(byPoolCodesAndCustomerCode);
        return costPoolReplenishments;
    }

    @Override
    public List<CostPoolReplenishment> findByCustomerCode(String customerCode) {
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return new ArrayList<CostPoolReplenishment>(0);
        }
        return this.costPoolReplenishmentRepository.findByCustomerCode(customerCode);
    }

    private void createValidate(CostPoolReplenishment costPoolReplenishment) {
        Validate.notNull((Object)((Object)costPoolReplenishment), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        costPoolReplenishment.setId(null);
        Validate.notBlank((CharSequence)costPoolReplenishment.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getCustomerCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getCustomerName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishment.getFreezeAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u51bb\u7ed3\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishment.getHasUseAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5df2\u4f7f\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishment.getOccupyAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5360\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getPayType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getPoolCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getPoolGroup(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getPoolType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishment.getTotalAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u603b\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishment.getUsableAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5269\u4f59\u53ef\u4f7f\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getUseType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u4f7f\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(CostPoolReplenishment costPoolReplenishment) {
        Validate.notNull((Object)((Object)costPoolReplenishment), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getCustomerCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getCustomerName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishment.getFreezeAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u51bb\u7ed3\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishment.getHasUseAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5df2\u4f7f\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishment.getOccupyAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5360\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getPayType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getPoolCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getPoolGroup(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getPoolType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishment.getTotalAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u603b\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishment.getUsableAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5269\u4f59\u53ef\u4f7f\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishment.getUseType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8d39\u7528\u4f7f\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void handleAdjustValidate(CostPoolReplenishmentDto costPoolReplenishmentDto) {
        Validate.notNull((Object)costPoolReplenishmentDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolReplenishmentDto.getCustomerCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDto.getAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((costPoolReplenishmentDto.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        List byCustomerCodes = this.customerVoService.findByCustomerCodes((List)Lists.newArrayList((Object[])new String[]{costPoolReplenishmentDto.getCustomerCode()}));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)byCustomerCodes) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        costPoolReplenishmentDto.setCustomerName(((CustomerVo)byCustomerCodes.get(0)).getCustomerName());
        Validate.notBlank((CharSequence)costPoolReplenishmentDto.getCustomerName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateForm(CostPoolReplenishment costPoolReplenishment) {
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        costPoolReplenishment.setModifyAccount(loginUser.getAccount());
        costPoolReplenishment.setModifyName(loginUser.getUsername());
        costPoolReplenishment.setModifyTime(new Date());
    }

    private void createForm(CostPoolReplenishment costPoolReplenishment) {
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        Date date = new Date();
        costPoolReplenishment.setId(null);
        String ruleCode = StringUtils.join((Object[])new String[]{"HB", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        String code = (String)this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        costPoolReplenishment.setPoolCode(code);
        costPoolReplenishment.setCreateAccount(loginUser.getAccount());
        costPoolReplenishment.setCreateName(loginUser.getUsername());
        costPoolReplenishment.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        costPoolReplenishment.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        costPoolReplenishment.setCreateTime(date);
        costPoolReplenishment.setModifyAccount(loginUser.getAccount());
        costPoolReplenishment.setModifyName(loginUser.getUsername());
        costPoolReplenishment.setModifyTime(date);
        costPoolReplenishment.setTenantCode(TenantUtils.getTenantCode());
        costPoolReplenishment.setPayType(PoolPayTypeEnum.Replenishment.getDictCode());
        costPoolReplenishment.setUseType(PoolUseTypeEnum.DEFAULT.getDictCode());
        costPoolReplenishment.setPoolGroup(PoolGroupEnum.DEFAULT.getDictCode());
        costPoolReplenishment.setPoolType(PoolTypeEnum.Replenishment.getDictCode());
    }
}

