/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.replenishment.local.service.internal;

import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentProduct;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentProductService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOperationDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.CostPoolReplenishmentOperationGroupEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.service.CostPoolReplenishmentStatisticalVoService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentStatisticalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CostPoolReplenishmentStatisticalVoServiceImpl
implements CostPoolReplenishmentStatisticalVoService {
    @Autowired(required=false)
    private CostPoolReplenishmentService costPoolReplenishmentService;
    @Autowired(required=false)
    private CostPoolReplenishmentOperationService costPoolReplenishmentOperationService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CostPoolReplenishmentProductService costPoolReplenishmentProductService;

    public List<CostPoolReplenishmentStatisticalVo> statisticsByCustomerCodeAndDate(String customerCode, Date beginDate, Date endDate) {
        Validate.notBlank((CharSequence)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)beginDate, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)endDate, (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((endDate.compareTo(beginDate) > -1 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        List<CostPoolReplenishment> byCustomerCode = this.costPoolReplenishmentService.findByCustomerCode(customerCode);
        if (CollectionUtils.isEmpty(byCustomerCode)) {
            return new ArrayList<CostPoolReplenishmentStatisticalVo>();
        }
        List<String> poolCodes = byCustomerCode.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getPoolCode())).map(CostPoolReplenishment::getPoolCode).collect(Collectors.toList());
        CostPoolReplenishmentOperationDto nowDto = new CostPoolReplenishmentOperationDto();
        nowDto.setPoolCodeList(poolCodes);
        nowDto.setStartTime(beginDate);
        nowDto.setEndTime(endDate);
        List<CostPoolReplenishmentOperation> now = this.costPoolReplenishmentOperationService.findByPoolCodesAndDate(nowDto);
        CostPoolReplenishmentOperationDto beforeDto = new CostPoolReplenishmentOperationDto();
        beforeDto.setPoolCodeList(poolCodes);
        beforeDto.setEndTime(beginDate);
        List<CostPoolReplenishmentOperation> beginning = this.costPoolReplenishmentOperationService.findByPoolCodesAndDate(beforeDto);
        Map<String, List<CostPoolReplenishmentOperation>> nowMap = now.stream().collect(Collectors.groupingBy(CostPoolReplenishmentOperation::getPoolCode));
        Map<String, List<CostPoolReplenishmentOperation>> beginningMap = beginning.stream().collect(Collectors.groupingBy(CostPoolReplenishmentOperation::getPoolCode));
        List costPoolReplenishmentStatisticalVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(byCustomerCode, CostPoolReplenishment.class, CostPoolReplenishmentStatisticalVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (CostPoolReplenishmentStatisticalVo vo : costPoolReplenishmentStatisticalVos) {
            this.initializeAmount(vo);
            Map<String, BigDecimal> beginningStatisticalAmount = this.getStatisticalAmount(vo, beginningMap.get(vo.getPoolCode()));
            BigDecimal beginningOnAmount = beginningStatisticalAmount.get(CostPoolReplenishmentOperationGroupEnum.ON.getDictCode());
            BigDecimal beginningUseAmount = beginningStatisticalAmount.get(CostPoolReplenishmentOperationGroupEnum.USE.getDictCode());
            vo.setLastEndAmount(beginningOnAmount.subtract(beginningUseAmount.abs()));
            Map<String, BigDecimal> nowStatisticalAmount = this.getStatisticalAmount(vo, nowMap.get(vo.getPoolCode()));
            BigDecimal nowOnAmount = nowStatisticalAmount.get(CostPoolReplenishmentOperationGroupEnum.ON.getDictCode());
            BigDecimal nowUseAmount = nowStatisticalAmount.get(CostPoolReplenishmentOperationGroupEnum.USE.getDictCode());
            vo.setOnAmount(nowOnAmount);
            vo.setUsedAmount(nowUseAmount.abs());
            BigDecimal subtract = nowOnAmount.subtract(nowUseAmount.abs());
            BigDecimal nowUsableAmount = subtract.subtract(vo.getOccupyAmount().abs());
            vo.setUsableAmount(vo.getLastEndAmount().add(nowUsableAmount));
        }
        this.joiningProductMsg(costPoolReplenishmentStatisticalVos, poolCodes);
        return costPoolReplenishmentStatisticalVos;
    }

    private void joiningProductMsg(List<CostPoolReplenishmentStatisticalVo> costPoolReplenishmentStatisticalVos, List<String> poolCodes) {
        if (CollectionUtils.isEmpty(poolCodes)) {
            return;
        }
        List<CostPoolReplenishmentProduct> byPoolCodes = this.costPoolReplenishmentProductService.findByPoolCodes(poolCodes);
        if (CollectionUtils.isEmpty(byPoolCodes)) {
            return;
        }
        Map<String, List<CostPoolReplenishmentProduct>> productMap = byPoolCodes.stream().collect(Collectors.groupingBy(CostPoolReplenishmentProduct::getPoolCode));
        for (CostPoolReplenishmentStatisticalVo vo : costPoolReplenishmentStatisticalVos) {
            String poolCode = vo.getPoolCode();
            List<CostPoolReplenishmentProduct> products = productMap.get(poolCode);
            if (CollectionUtils.isEmpty(products)) continue;
            for (CostPoolReplenishmentProduct product : products) {
                if (StringUtils.isBlank((CharSequence)vo.getGoodsProductCode())) {
                    vo.setGoodsProductCode(product.getGoodsProductCode());
                } else {
                    String goodsProductCode = vo.getGoodsProductCode();
                    String code = goodsProductCode.concat(",").concat(product.getGoodsProductCode());
                    vo.setGoodsProductCode(code);
                }
                if (StringUtils.isBlank((CharSequence)vo.getGoodsProductName())) {
                    vo.setGoodsProductName(product.getGoodsProductName());
                    continue;
                }
                String goodsProductName = vo.getGoodsProductName();
                String name = goodsProductName.concat(",").concat(product.getGoodsProductName());
                vo.setGoodsProductName(name);
            }
        }
    }

    private Map<String, BigDecimal> getStatisticalAmount(CostPoolReplenishmentStatisticalVo vo, List<CostPoolReplenishmentOperation> costPoolReplenishmentOperations) {
        HashMap<String, BigDecimal> res = new HashMap<String, BigDecimal>();
        res.put(CostPoolReplenishmentOperationGroupEnum.ON.getDictCode(), BigDecimal.ZERO);
        res.put(CostPoolReplenishmentOperationGroupEnum.USE.getDictCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(costPoolReplenishmentOperations)) {
            return res;
        }
        BigDecimal onAmount = BigDecimal.ZERO;
        BigDecimal usedAmount = BigDecimal.ZERO;
        for (CostPoolReplenishmentOperation operation : costPoolReplenishmentOperations) {
            String operationType = operation.getOperationType();
            PoolOperationTypeEnum typeEnum = PoolOperationTypeEnum.getByKey((String)operationType);
            if (typeEnum != null && typeEnum.getGroupEnum() == CostPoolReplenishmentOperationGroupEnum.ON) {
                onAmount = onAmount.add(operation.getOperationAmount());
            }
            if (typeEnum == null || typeEnum.getGroupEnum() != CostPoolReplenishmentOperationGroupEnum.USE) continue;
            usedAmount = usedAmount.add(operation.getOperationAmount());
        }
        if (Objects.nonNull(onAmount)) {
            res.put(CostPoolReplenishmentOperationGroupEnum.ON.getDictCode(), onAmount);
        }
        if (Objects.nonNull(usedAmount)) {
            res.put(CostPoolReplenishmentOperationGroupEnum.USE.getDictCode(), usedAmount);
        }
        return res;
    }

    private void initializeAmount(CostPoolReplenishmentStatisticalVo vo) {
        vo.setOnAmount(BigDecimal.ZERO);
        vo.setOccupyAmount(BigDecimal.ZERO);
        vo.setUsedAmount(BigDecimal.ZERO);
        vo.setLastEndAmount(BigDecimal.ZERO);
        vo.setUsableAmount(BigDecimal.ZERO);
    }
}

