/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.replenishment.local.service.observer;

import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOperationDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.CostPoolReplenishmentOperationGroupEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolTypeEnum;
import com.biz.crm.dms.business.costpool.sdk.enums.CostPoolSummaryEnum;
import com.biz.crm.dms.business.costpool.sdk.observer.CostPoolAmountStatisticsObserver;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolAmountStatisticsVo;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CostPoolAmountStatisticsReplenishmentServerImpl
implements CostPoolAmountStatisticsObserver {
    @Autowired(required=false)
    private CostPoolReplenishmentService costPoolReplenishmentService;
    @Autowired(required=false)
    private CostPoolReplenishmentOperationService costPoolReplenishmentOperationService;

    public List<CostPoolAmountStatisticsVo> findAmountStatisticsVoByCustomerCodeAndDate(String customerCode, Date beginDate, Date endDate) {
        Validate.notBlank((CharSequence)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)beginDate, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)endDate, (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((endDate.compareTo(beginDate) > -1 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        ArrayList<CostPoolAmountStatisticsVo> res = new ArrayList<CostPoolAmountStatisticsVo>();
        List<CostPoolReplenishment> byCustomerCode = this.costPoolReplenishmentService.findByCustomerCode(customerCode);
        List poolCodes = byCustomerCode.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getPoolCode())).map(CostPoolReplenishment::getPoolCode).collect(Collectors.toList());
        List<Object> list = new ArrayList();
        List<Object> beforeDateList = new ArrayList();
        if (!CollectionUtils.isEmpty(poolCodes)) {
            CostPoolReplenishmentOperationDto operationDto = new CostPoolReplenishmentOperationDto();
            operationDto.setPoolCodeList(poolCodes);
            operationDto.setStartTime(beginDate);
            operationDto.setEndTime(endDate);
            list = this.costPoolReplenishmentOperationService.findByPoolCodesAndDate(operationDto);
            CostPoolReplenishmentOperationDto beforeDateDto = new CostPoolReplenishmentOperationDto();
            beforeDateDto.setPoolCodeList(poolCodes);
            beforeDateDto.setStartTime(beginDate);
            beforeDateList = this.costPoolReplenishmentOperationService.findByPoolCodesAndBeforeDate(beforeDateDto);
        }
        Map<String, List<CostPoolReplenishmentOperation>> map = list.stream().collect(Collectors.groupingBy(CostPoolReplenishmentOperation::getOperationType));
        Map<String, List<CostPoolReplenishmentOperation>> beforeDateMap = beforeDateList.stream().collect(Collectors.groupingBy(CostPoolReplenishmentOperation::getOperationType));
        List<CostPoolAmountStatisticsVo> now = this.countData(map);
        BigDecimal nowAmount = now.stream().map(CostPoolAmountStatisticsVo::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<CostPoolAmountStatisticsVo> before = this.countData(beforeDateMap);
        BigDecimal beforeAmount = before.stream().map(CostPoolAmountStatisticsVo::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal afterAmount = beforeAmount.add(nowAmount);
        for (CostPoolAmountStatisticsVo vo : now) {
            vo.setTotalAmount(vo.getTotalAmount().abs());
        }
        res.addAll(now);
        CostPoolAmountStatisticsVo beforeObj = new CostPoolAmountStatisticsVo();
        beforeObj.setTotalAmount(beforeAmount.abs());
        beforeObj.setPoolType(PoolTypeEnum.Replenishment.getKey());
        beforeObj.setSummary(CostPoolSummaryEnum.BEGIN.getKey());
        res.add(beforeObj);
        CostPoolAmountStatisticsVo afterObj = new CostPoolAmountStatisticsVo();
        afterObj.setTotalAmount(afterAmount.abs());
        afterObj.setPoolType(PoolTypeEnum.Replenishment.getKey());
        afterObj.setSummary(CostPoolSummaryEnum.END.getKey());
        res.add(afterObj);
        return res;
    }

    private List<CostPoolAmountStatisticsVo> countData(Map<String, List<CostPoolReplenishmentOperation>> map) {
        ArrayList<CostPoolAmountStatisticsVo> count = new ArrayList<CostPoolAmountStatisticsVo>();
        AtomicReference<BigDecimal> onSum = new AtomicReference<BigDecimal>(new BigDecimal(BigInteger.ZERO));
        CostPoolAmountStatisticsVo onVo = new CostPoolAmountStatisticsVo();
        AtomicReference<BigDecimal> useSum = new AtomicReference<BigDecimal>(new BigDecimal(BigInteger.ZERO));
        CostPoolAmountStatisticsVo useVo = new CostPoolAmountStatisticsVo();
        AtomicReference<BigDecimal> occupySum = new AtomicReference<BigDecimal>(new BigDecimal(BigInteger.ZERO));
        CostPoolAmountStatisticsVo occupyVo = new CostPoolAmountStatisticsVo();
        map.forEach((k, v) -> {
            block4: {
                block5: {
                    block3: {
                        if (!k.equals(PoolOperationTypeEnum.INIT.getKey()) && !k.equals(PoolOperationTypeEnum.MANUAL_ACCOUNT.getKey()) && !k.equals(PoolOperationTypeEnum.REBATE_ACCOUNT.getKey()) && !k.equals(PoolOperationTypeEnum.FREEZE.getKey()) && !k.equals(PoolOperationTypeEnum.UNFREEZE.getKey()) && !k.equals(PoolOperationTypeEnum.ACT_ACCOUNT.getKey())) break block3;
                        for (CostPoolReplenishmentOperation op : v) {
                            onSum.getAndUpdate(b -> b.add(op.getOperationAmount()));
                        }
                        break block4;
                    }
                    if (!k.equals(PoolOperationTypeEnum.MANUAL_INDUCE.getKey()) && !k.equals(PoolOperationTypeEnum.ORDER_USE.getKey())) break block5;
                    for (CostPoolReplenishmentOperation op : v) {
                        useSum.getAndUpdate(b -> b.add(op.getOperationAmount()));
                    }
                    break block4;
                }
                if (!k.equals(PoolOperationTypeEnum.OCCUPY_USE.getKey()) && !k.equals(PoolOperationTypeEnum.OCCUPY_RELEASE.getKey())) break block4;
                for (CostPoolReplenishmentOperation op : v) {
                    occupySum.getAndUpdate(b -> b.add(op.getOperationAmount()));
                }
            }
        });
        onVo.setSummary(CostPoolReplenishmentOperationGroupEnum.ON.getKey());
        onVo.setTotalAmount(onSum.get());
        onVo.setPoolType(PoolTypeEnum.Replenishment.getKey());
        useVo.setSummary(CostPoolReplenishmentOperationGroupEnum.USE.getKey());
        useVo.setTotalAmount(useSum.get());
        useVo.setPoolType(PoolTypeEnum.Replenishment.getKey());
        occupyVo.setSummary(CostPoolReplenishmentOperationGroupEnum.OCCUPY.getKey());
        occupyVo.setTotalAmount(occupySum.get());
        occupyVo.setPoolType(PoolTypeEnum.Replenishment.getKey());
        count.add(onVo);
        count.add(useVo);
        count.add(occupyVo);
        return count;
    }
}

