/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.replenishment.local.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentProduct;
import com.biz.crm.dms.business.costpool.replenishment.local.repository.CostPoolReplenishmentProductRepository;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentVo;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CostPoolReplenishmentStrategyImpl
implements CostPoolStrategy {
    @Autowired(required=false)
    @Qualifier(value="CostPoolReplenishmentRegisterImpl")
    private CostPoolRegister costPoolRegister;
    @Autowired(required=false)
    private CostPoolReplenishmentService costPoolReplenishmentService;
    @Autowired(required=false)
    private CostPoolReplenishmentProductRepository costPoolReplenishmentProductRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getPoolTypeRegisterKey() {
        return this.costPoolRegister.getKey();
    }

    public List<CostPoolVo> onRequestCostPoolVos(CostPoolDto costPoolDto) {
        List<String> list;
        List<Object> byPoolCodesAndCustomerCode = new ArrayList();
        byPoolCodesAndCustomerCode = CollectionUtils.isEmpty((Collection)costPoolDto.getPoolCodeList()) ? this.costPoolReplenishmentService.findByCustomerCode(costPoolDto.getCustomerCode()) : this.costPoolReplenishmentService.findByPoolCodesAndCustomerCode(costPoolDto.getPoolCodeList(), costPoolDto.getCustomerCode());
        List<String> poolCodes = byPoolCodesAndCustomerCode.stream().map(CostPoolReplenishment::getPoolCode).collect(Collectors.toList());
        Map<Object, Object> productMap = new HashMap();
        if (!CollectionUtils.isEmpty(poolCodes)) {
            List<CostPoolReplenishmentProduct> products = this.costPoolReplenishmentProductRepository.findByPoolCodes(poolCodes);
            productMap = products.stream().collect(Collectors.groupingBy(CostPoolReplenishmentProduct::getPoolCode));
        }
        HashMap map = new HashMap();
        for (CostPoolReplenishment costPoolReplenishment : byPoolCodesAndCustomerCode) {
            List costPoolReplenishmentProduct = (List)productMap.get(costPoolReplenishment.getPoolCode());
            costPoolReplenishment.setCostPoolReplenishmentProduct(costPoolReplenishmentProduct);
            if (CollectionUtils.isEmpty((Collection)costPoolReplenishmentProduct)) continue;
            list = new ArrayList<String>();
            for (CostPoolReplenishmentProduct poolReplenishmentProduct : costPoolReplenishmentProduct) {
                list.add(poolReplenishmentProduct.getGoodsProductCode());
            }
            map.put(costPoolReplenishment.getPoolCode(), list);
        }
        List result = (List)this.nebulaToolkitService.copyCollectionByWhiteList(byPoolCodesAndCustomerCode, CostPoolReplenishment.class, CostPoolReplenishmentVo.class, HashSet.class, ArrayList.class, new String[]{"costPoolReplenishmentProduct"});
        for (CostPoolReplenishmentVo costPoolReplenishmentVo : result) {
            if (!map.containsKey(costPoolReplenishmentVo.getPoolCode())) continue;
            list = (List)map.get(costPoolReplenishmentVo.getPoolCode());
            costPoolReplenishmentVo.setProductCodes(list);
        }
        return result;
    }

    public void onHandleAdjust(JSONObject jsonObject) {
        CostPoolReplenishmentDto costPoolReplenishmentDto = (CostPoolReplenishmentDto)JsonUtils.json2Obj((String)jsonObject.toJSONString(), CostPoolReplenishmentDto.class);
        this.costPoolReplenishmentService.handleAdjust(costPoolReplenishmentDto);
    }
}

