/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.replenishment.local.service.strategy;

import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetail;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetailLog;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentFile;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailLogService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentFileDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentProductDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.strategy.OperationTypeStrategy;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class ReplenishmentAccountOperationTypeStrategyImpl
implements OperationTypeStrategy {
    @Autowired(required=false)
    private CostPoolReplenishmentService costPoolReplenishmentService;
    @Autowired(required=false)
    private CostPoolReplenishmentDetailService costPoolReplenishmentDetailService;
    @Autowired(required=false)
    private CostPoolReplenishmentDetailLogService costPoolReplenishmentDetailLogService;
    @Autowired(required=false)
    private CostPoolReplenishmentOperationService costPoolReplenishmentOperationService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public String getOperationTypeGroup() {
        return PoolOperationTypeGroupEnum.ACCOUNT.getValue();
    }

    @Transactional
    public void onSaveDiscountInfos(CostPoolReplenishmentDto costPoolReplenishmentDto) {
        Date date = new Date();
        BigDecimal amount = costPoolReplenishmentDto.getAmount();
        CostPoolReplenishment costPoolReplenishment = new CostPoolReplenishment();
        CostPoolReplenishment poolReplenishment = null;
        if (StringUtils.isNotBlank((CharSequence)costPoolReplenishmentDto.getPoolCode())) {
            poolReplenishment = this.costPoolReplenishmentService.findByPoolCode(costPoolReplenishmentDto.getPoolCode());
            if (ObjectUtils.isEmpty((Object)((Object)poolReplenishment))) {
                throw new IllegalArgumentException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7f16\u7801\u7684\u8d27\u8865\u6c60");
            }
        } else {
            this.validateProductAndLevel(costPoolReplenishmentDto);
            poolReplenishment = this.costPoolReplenishmentService.findByCostPoolReplenishmentDto(costPoolReplenishmentDto);
        }
        if (!Objects.isNull((Object)poolReplenishment)) {
            Validate.isTrue((!PoolOperationTypeEnum.INIT.getDictCode().equals(costPoolReplenishmentDto.getOperationType()) ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u7c7b\u578b\u4e3a\u671f\u521d\u65f6\uff0c\u6570\u636e\u5df2\u5b58\u5728\u4e0d\u80fd\u518d\u671f\u521d\u4e0a\u8d26", (Object[])new Object[0]);
            poolReplenishment.setTotalAmount(poolReplenishment.getTotalAmount().add(amount));
            poolReplenishment.setUsableAmount(poolReplenishment.getUsableAmount().add(amount));
            this.costPoolReplenishmentService.update(poolReplenishment);
            costPoolReplenishment = poolReplenishment;
        } else {
            costPoolReplenishment = (CostPoolReplenishment)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)costPoolReplenishmentDto, CostPoolReplenishment.class, HashSet.class, ArrayList.class, new String[]{"costPoolReplenishmentProduct"}));
            costPoolReplenishment.setPoolCode(String.valueOf(System.currentTimeMillis()));
            costPoolReplenishment.setFreezeAmount(BigDecimal.ZERO);
            costPoolReplenishment.setOccupyAmount(BigDecimal.ZERO);
            costPoolReplenishment.setUsableAmount(amount);
            costPoolReplenishment.setHasUseAmount(BigDecimal.ZERO);
            costPoolReplenishment.setTotalAmount(amount);
            this.costPoolReplenishmentService.create(costPoolReplenishment);
        }
        CostPoolReplenishmentOperation costPoolDiscountOperation = new CostPoolReplenishmentOperation();
        costPoolDiscountOperation.setPoolCode(costPoolReplenishment.getPoolCode());
        costPoolDiscountOperation.setOperationType(costPoolReplenishmentDto.getOperationType());
        costPoolDiscountOperation.setFromCode(costPoolReplenishmentDto.getFromCode());
        costPoolDiscountOperation.setFromDesc(costPoolReplenishmentDto.getFromDesc());
        costPoolDiscountOperation.setOperationDateTime(date);
        costPoolDiscountOperation.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight()));
        Set costPoolDiscountFiles = costPoolReplenishmentDto.getCostPoolReplenishmentFileDtos();
        if (!CollectionUtils.isEmpty((Collection)costPoolDiscountFiles)) {
            Set files = (Set)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)costPoolDiscountFiles, CostPoolReplenishmentFileDto.class, CostPoolReplenishmentFile.class, HashSet.class, ArrayList.class, new String[0]);
            costPoolDiscountOperation.setCostPoolReplenishmentFiles(files);
        }
        this.costPoolReplenishmentOperationService.create(costPoolDiscountOperation);
        CostPoolReplenishmentDetail costPoolReplenishmentDetail = (CostPoolReplenishmentDetail)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)costPoolReplenishment, CostPoolReplenishmentDetail.class, HashSet.class, ArrayList.class, new String[]{"id"}));
        costPoolReplenishmentDetail.setFromCode(costPoolReplenishmentDto.getFromCode());
        costPoolReplenishmentDetail.setFromDesc(costPoolReplenishmentDto.getFromDesc());
        costPoolReplenishmentDetail.setOperationType(costPoolReplenishmentDto.getOperationType());
        costPoolReplenishmentDetail.setOperationCode(costPoolDiscountOperation.getOperationCode());
        costPoolReplenishmentDetail.setAccountDateTime(date);
        costPoolReplenishmentDetail.setFreezeAmount(BigDecimal.ZERO);
        costPoolReplenishmentDetail.setOccupyAmount(BigDecimal.ZERO);
        costPoolReplenishmentDetail.setUsableAmount(amount);
        costPoolReplenishmentDetail.setHasUseAmount(BigDecimal.ZERO);
        costPoolReplenishmentDetail.setTotalAmount(amount);
        this.costPoolReplenishmentDetailService.create(costPoolReplenishmentDetail);
        CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog = (CostPoolReplenishmentDetailLog)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)costPoolReplenishmentDetail, CostPoolReplenishmentDetailLog.class, HashSet.class, ArrayList.class, new String[]{"id"}));
        costPoolReplenishmentDetailLog.setProductCode(costPoolReplenishmentDto.getGoodsProductLevelCode());
        costPoolReplenishmentDetailLog.setProductName(costPoolReplenishmentDto.getGoodsProductLevelName());
        costPoolReplenishmentDetailLog.setOperationDateTime(date);
        costPoolReplenishmentDetailLog.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.ACCOUNT.getUsableAmountWeight()));
        this.costPoolReplenishmentDetailLogService.create(costPoolReplenishmentDetailLog);
    }

    private void validateProductAndLevel(CostPoolReplenishmentDto costPoolReplenishmentDto) {
        List listByCodes = this.productLevelVoSdkService.findListByCodes((List)Lists.newArrayList((Object[])new String[]{costPoolReplenishmentDto.getGoodsProductLevelCode()}));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)listByCodes) ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List costPoolReplenishmentProduct = costPoolReplenishmentDto.getCostPoolReplenishmentProduct();
        if (CollectionUtils.isEmpty((Collection)costPoolReplenishmentProduct)) {
            return;
        }
        List<String> productCodeList = costPoolReplenishmentProduct.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getGoodsProductCode())).map(CostPoolReplenishmentProductDto::getGoodsProductCode).collect(Collectors.toList());
        List detailsByIdsOrCodes = this.productVoService.findDetailsByIdsOrProductCodes(new LinkedList(), productCodeList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)detailsByIdsOrCodes) ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        HashMap<String, ProductVo> productVoMap = new HashMap<String, ProductVo>();
        productVoMap.putAll(detailsByIdsOrCodes.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v)));
        productCodeList.forEach(e -> Validate.isTrue((boolean)productVoMap.containsKey(e), (String)("\u4ea7\u54c1\u7f16\u7801[" + e + "]\u65e0\u6548"), (Object[])new Object[0]));
        String goodsProductLevelCode = costPoolReplenishmentDto.getGoodsProductLevelCode();
        List byProductLevelCodes = this.productVoService.findByProductLevelCodes((List)Lists.newArrayList((Object[])new String[]{goodsProductLevelCode}));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)byProductLevelCodes) ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u5c42\u7ea7\u548c\u4ea7\u54c1\u5bf9\u5e94\u5173\u7cfb\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Map<String, String> map = byProductLevelCodes.stream().collect(Collectors.toMap(ProductVo::getProductCode, ProductVo::getProductLevelCode));
        for (CostPoolReplenishmentProductDto costPoolReplenishmentProductDto : costPoolReplenishmentDto.getCostPoolReplenishmentProduct()) {
            Validate.isTrue((boolean)goodsProductLevelCode.equals(map.get(costPoolReplenishmentProductDto.getGoodsProductCode())), (String)("\u5546\u54c1[" + costPoolReplenishmentProductDto.getGoodsProductCode() + "]\u4e0d\u5c5e\u4e8e\u4ea7\u54c1\u5c42\u7ea7[" + goodsProductLevelCode + "]"), (Object[])new Object[0]);
        }
    }
}

