/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.replenishment.local.service.strategy;

import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishment;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetail;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentDetailLog;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentFile;
import com.biz.crm.dms.business.costpool.replenishment.local.entity.CostPoolReplenishmentOperation;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailLogService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentDetailService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentOperationService;
import com.biz.crm.dms.business.costpool.replenishment.local.service.CostPoolReplenishmentService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentFileDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.strategy.OperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class ReplenishmentOccupyReleaseOperationTypeStrategyImpl
implements OperationTypeStrategy {
    @Autowired(required=false)
    private CostPoolReplenishmentService costPoolReplenishmentService;
    @Autowired(required=false)
    private CostPoolReplenishmentDetailService costPoolReplenishmentDetailService;
    @Autowired(required=false)
    private CostPoolReplenishmentOperationService costPoolReplenishmentOperationService;
    @Autowired(required=false)
    private CostPoolReplenishmentDetailLogService costPoolReplenishmentDetailLogService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getOperationTypeGroup() {
        return PoolOperationTypeGroupEnum.OCCUPY_RELEASE.getValue();
    }

    @Transactional
    public void onSaveDiscountInfos(CostPoolReplenishmentDto costPoolReplenishmentDto) {
        Validate.notNull((Object)costPoolReplenishmentDto.getPoolCode(), (String)"\u8fdb\u884c\u5360\u7528\u91ca\u653e\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u7801\u5fc5\u4f20\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDto.getFromCode(), (String)"\u8fdb\u884c\u5360\u7528\u91ca\u653e\u65f6\uff0c\u6765\u6e90\u7f16\u7801\u5fc5\u4f20\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolReplenishmentDto.getFromDesc(), (String)"\u8fdb\u884c\u5360\u7528\u91ca\u653e\u65f6\uff0c\u6765\u6e90\u63cf\u8ff0\u5fc5\u4f20\uff01", (Object[])new Object[0]);
        Date date = new Date();
        BigDecimal amount = costPoolReplenishmentDto.getAmount();
        CostPoolReplenishment poolReplenishment = this.costPoolReplenishmentService.findByPoolCode(costPoolReplenishmentDto.getPoolCode());
        Validate.notNull((Object)((Object)poolReplenishment), (String)"\u8fdb\u884c\u5360\u7528\u91ca\u653e\u65f6\u672a\u67e5\u8be2\u5230\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((poolReplenishment.getOccupyAmount().compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5360\u7528\u91ca\u653e\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u8d27\u8865\u6c60\u5360\u7528\u91d1\u989d", (Object[])new Object[0]);
        poolReplenishment.setOccupyAmount(poolReplenishment.getOccupyAmount().subtract(amount));
        poolReplenishment.setUsableAmount(poolReplenishment.getUsableAmount().add(amount));
        this.costPoolReplenishmentService.update(poolReplenishment);
        CostPoolReplenishmentOperation costPoolReplenishmentOperation = new CostPoolReplenishmentOperation();
        costPoolReplenishmentOperation.setPoolCode(poolReplenishment.getPoolCode());
        costPoolReplenishmentOperation.setOperationType(costPoolReplenishmentDto.getOperationType());
        costPoolReplenishmentOperation.setFromCode(costPoolReplenishmentDto.getFromCode());
        costPoolReplenishmentOperation.setFromDesc(costPoolReplenishmentDto.getFromDesc());
        costPoolReplenishmentOperation.setOperationDateTime(new Date());
        costPoolReplenishmentOperation.setCreateTime(new Date());
        costPoolReplenishmentOperation.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.OCCUPY_RELEASE.getUsableAmountWeight()));
        Set costPoolDiscountFiles = costPoolReplenishmentDto.getCostPoolReplenishmentFileDtos();
        if (!CollectionUtils.isEmpty((Collection)costPoolDiscountFiles)) {
            Set files = (Set)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)costPoolDiscountFiles, CostPoolReplenishmentFileDto.class, CostPoolReplenishmentFile.class, HashSet.class, ArrayList.class, new String[0]);
            costPoolReplenishmentOperation.setCostPoolReplenishmentFiles(files);
        }
        this.costPoolReplenishmentOperationService.create(costPoolReplenishmentOperation);
        ArrayList<CostPoolReplenishmentDetail> replenishmentDetailList = new ArrayList<CostPoolReplenishmentDetail>();
        ArrayList<CostPoolReplenishmentDetailLog> detailLogList = new ArrayList<CostPoolReplenishmentDetailLog>();
        List<CostPoolReplenishmentDetail> costPoolReplenishmentDetails = this.costPoolReplenishmentDetailService.findByPoolCodeAndFromCode(costPoolReplenishmentDto.getPoolCode(), costPoolReplenishmentDto.getFromCode());
        for (CostPoolReplenishmentDetail costPoolReplenishmentDetail : costPoolReplenishmentDetails) {
            if (amount.compareTo(BigDecimal.ZERO) <= 0) break;
            if (costPoolReplenishmentDetail.getOccupyAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal itemUse = BigDecimal.ZERO;
            itemUse = costPoolReplenishmentDetail.getOccupyAmount().compareTo(amount) >= 0 ? amount : costPoolReplenishmentDetail.getOccupyAmount();
            amount = amount.subtract(itemUse);
            Validate.isTrue((costPoolReplenishmentDetail.getUsableAmount().compareTo(itemUse) >= 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u65f6\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u53ef\u7528\u91d1\u989d", (Object[])new Object[0]);
            costPoolReplenishmentDetail.setOccupyAmount(costPoolReplenishmentDetail.getOccupyAmount().subtract(itemUse));
            costPoolReplenishmentDetail.setUsableAmount(costPoolReplenishmentDetail.getUsableAmount().add(itemUse));
            replenishmentDetailList.add(costPoolReplenishmentDetail);
            CostPoolReplenishmentDetailLog costPoolReplenishmentDetailLog = (CostPoolReplenishmentDetailLog)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)costPoolReplenishmentDetail, CostPoolReplenishmentDetailLog.class, HashSet.class, ArrayList.class, new String[]{"id"}));
            costPoolReplenishmentDetailLog.setOperationDateTime(date);
            costPoolReplenishmentDetailLog.setOperationCode(costPoolReplenishmentOperation.getOperationCode());
            costPoolReplenishmentDetailLog.setOperationType(costPoolReplenishmentDto.getOperationType());
            costPoolReplenishmentDetailLog.setFromCode(costPoolReplenishmentDto.getFromCode());
            costPoolReplenishmentDetailLog.setFromDesc(costPoolReplenishmentDto.getFromDesc());
            costPoolReplenishmentDetailLog.setOperationAmount(itemUse.multiply(PoolOperationTypeGroupEnum.OCCUPY_RELEASE.getUsableAmountWeight()));
            detailLogList.add(costPoolReplenishmentDetailLog);
        }
        Validate.isTrue((amount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u5360\u7528\u91ca\u653e\u91d1\u989d\u4e0d\u80fd\u8d85\u51fa\u5360\u7528\u91d1\u989d", (Object[])new Object[0]);
        this.costPoolReplenishmentDetailService.updateBatch(replenishmentDetailList);
        this.costPoolReplenishmentDetailLogService.createBatch(detailLogList);
    }
}

