package com.biz.crm.dms.business.costpool.replenishment.sdk.dto;

import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Set;

/**
 * 货补费用池
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "货补费用池Dto")
public class CostPoolReplenishmentDto extends CostPoolDto {


  /**
   * 费用池分组
   */
  @ApiModelProperty(value = "费用池分组")
  private String poolGroup;
  /**
   * 费用池编号
   */
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;
  /**
   * 费用池明细编号
   */
  @ApiModelProperty(value = "费用池明细编号")
  private String poolDetailCode;

  /**
   * 费用池分组
   */
  @ApiModelProperty(value = "费用池明细ID")
  private String detailId;

  /**
   * 支付方式
   */
  @ApiModelProperty(value = "支付方式")
  private String payType;
  /**
   * 费用使用类型
   */
  @ApiModelProperty(value = "费用使用类型")
  private String useType;
  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String customerName;
  /**
   * 操作类型
   */
  @ApiModelProperty(value = "操作类型")
  private String operationType;
  /**
   * 备注
   */
  @ApiModelProperty(value = "备注")
  private String remark;
  /**
   * 货补产品层级编码
   */
  @ApiModelProperty(value = "货补产品层级编码")
  private String goodsProductLevelCode;
  /**
   * 货补产品层级名称
   */
  @ApiModelProperty(value = "货补产品层级名称")
  private String goodsProductLevelName;

  /**
   * 货补商品编码
   */
  @ApiModelProperty(value = "货补商品编码")
  private String goodsProductCode;
  /**
   * 货补商品名称
   */
  @ApiModelProperty(value = "货补商品名称")
  private String goodsProductName;
  /**
   * 渠道类型
   */
  @ApiModelProperty(value = "渠道类型")
  private String channelType;
  /**
   * 附件信息集合
   */
  @ApiModelProperty("附件信息集合")
  private Set<CostPoolReplenishmentFileDto> costPoolReplenishmentFileDtos;

  /**
   * 货补商品信息
   */
  private List<CostPoolReplenishmentProductDto> costPoolReplenishmentProduct;
}
