package com.biz.crm.dms.business.costpool.replenishment.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.costpool.replenishment.sdk.dto
 * @ClassName CostPoolReplenishmentOperationDto
 * @Author YangWei
 * @Date 2022/3/23 下午2:53
 * @Description 货补费用池操作明细Dto
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CostPoolReplenishmentOperationDto",description = "货补费用池操作明细Dto")
public class CostPoolReplenishmentOperationDto extends TenantDto {

  /**
   * 货补池编号
   */
  @ApiModelProperty(value = "货补池编号")
  private List<String> poolCodeList;

  /**
   * 操作明细大类（上账/使用）
   */
  @ApiModelProperty(name = "group", value = "操作明细大类（上账/使用)", required = true)
  private String group;

  /** 操作类型集合 */
  @ApiModelProperty(name = "operationTypeList", value = "操作类型")
  private List<String> operationTypeList;

  /**
   * 查询期间开始时间
   */
  @ApiModelProperty("查询期间开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;

  /**
   * 查询期间结束时间
   */
  @ApiModelProperty("查询期间结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;
}