package com.biz.crm.dms.business.costpool.replenishment.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description 货补池操作分组
 * @Author YangWei
 * @Date Created in 2022/3/23 上午11:39
 */
public enum CostPoolReplenishmentOperationGroupEnum {
  /**
   * 上账
   */
  ON("keep_books", "1", "上账", "1"),

  /**
   * 使用
   */
  USE("used", "2", "使用", "2"),

  /**
   * 占用
   */
  OCCUPY("occupy", "3", "占用", "3"),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  CostPoolReplenishmentOperationGroupEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 CapitalAdjustTypeEnum
   *
   * @param key
   * @return
   */
  public static CostPoolReplenishmentOperationGroupEnum getByKey(String key) {
    return Arrays.stream(CostPoolReplenishmentOperationGroupEnum.values())
        .filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

  /**
   * 通过dictCode获取Enum
   *
   * @param dictCode
   * @return
   */
  public static CostPoolReplenishmentOperationGroupEnum getByDictCode(String dictCode) {
    return Arrays.stream(CostPoolReplenishmentOperationGroupEnum.values())
        .filter(item -> Objects.equals(item.getDictCode(), dictCode)).findFirst().orElse(null);
  }
}
