package com.biz.crm.dms.business.costpool.replenishment.sdk.enums;

import java.math.BigDecimal;

/**
 * 费用池操作类型分组枚举
 * @author songjingen
 */
public enum PoolOperationTypeGroupEnum {

  ACCOUNT("account", "上账类", "总金额增加，使用金额不变，冻结金额不变，占用金额不变，可用金额增加", BigDecimal.ONE),
  USE("use", "使用扣减类", "总金额不变，使用金额增加，冻结金额不变，占用金额不变，可用金额减少", BigDecimal.ONE.negate()),
  FREEZE("freeze", "冻结类", "总金额不变，使用金额不变，冻结金额增加，占用金额不变，可用金额减少", BigDecimal.ONE.negate()),
  UNFREEZE("unfreeze", "解冻类", "总金额不变，使用金额不变，冻结金额减少，占用金额不变，可用金额增加", BigDecimal.ONE),
  OCCUPY_USE("occupy_use", "占用类", "总金额不变，使用金额不变，冻结金额不变，占用金额增加，可用金额减少", BigDecimal.ONE.negate()),
  OCCUPY_RELEASE("occupy_release", "释放类", "总金额不变，使用金额不变，冻结金额不变，占用金额减少，可用金额增加", BigDecimal.ONE),
  ;

  private String value;
  private String desc;
  private String text;
  /***可用金额权重*/
  private BigDecimal usableAmountWeight;

  PoolOperationTypeGroupEnum(String value, String desc, String text, BigDecimal usableAmountWeight) {
    this.value = value;
    this.desc = desc;
    this.text = text;
    this.usableAmountWeight = usableAmountWeight;
  }

  public static PoolOperationTypeGroupEnum getEnum(String value) {
    if (value != null && !"".equals(value)) {
      for (PoolOperationTypeGroupEnum item :
          PoolOperationTypeGroupEnum.values()) {
        if (value.equals(item.getValue())) {
          return item;
        }
      }
    }
    return null;
  }

  public String getValue() {
    return value;
  }

  public String getText() {
    return text;
  }

  public String getDesc() {
    return desc;
  }

  public BigDecimal getUsableAmountWeight() {
    return usableAmountWeight;
  }
}


