package com.biz.crm.dms.business.costpool.replenishment.sdk.enums;


import java.util.Arrays;
import java.util.Objects;

/**
 * 费用池类型
 * @author songjingen
 */
public enum PoolTypeEnum {

  Replenishment("replenishment", "replenishment", "货补费用池", "1"),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  PoolTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 CapitalAdjustTypeEnum
   *
   * @param key
   * @return
   */
  public static PoolTypeEnum getByKey(String key) {
    return Arrays.stream(PoolTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

}
