package com.biz.crm.dms.business.costpool.replenishment.sdk.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author HanJiaJun
 * @describe:货补费用池明细Vo
 * @createTime 2021年12月27日 17:23:00
 */
@Data
public class CostPoolReplenishmentDetailVo {
  /**
   * 费用池编号
   */
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;
  /**
   * 费用池明细编号
   */
  @ApiModelProperty(value = "费用池明细编号")
  private String poolDetailCode;
  /**
   * 操作记录编号
   */
  @ApiModelProperty(value = "操作记录编号")
  private String operationCode;
  /**
   * 操作类型
   */
  @ApiModelProperty(value = "操作类型")
  private String operationType;
  /**
   * 来源编号
   */
  @ApiModelProperty(value = "来源编号")
  private String fromCode;
  /**
   * 来源描述
   */
  @ApiModelProperty(value = "来源描述")
  private String fromDesc;
  /**
   * 上账时间
   */
  @ApiModelProperty(value = "上账时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date accountDateTime;
  /**
   * 总金额（数量）
   */
  @ApiModelProperty(value = "总金额")
  private BigDecimal totalAmount;
  /**
   * 冻结金额（数量）
   */
  @ApiModelProperty(value = "冻结金额")
  private BigDecimal freezeAmount;
  /**
   * 占用金额（数量）
   */
  @ApiModelProperty(value = "占用金额")
  private BigDecimal occupyAmount;
  /**
   * 已使用金额（数量）
   */
  @ApiModelProperty(value = "已使用金额")
  private BigDecimal hasUseAmount;
  /**
   * 剩余可使用金额（数量）
   */
  @ApiModelProperty(value = "剩余可使用金额")
  private BigDecimal usableAmount;
}