package com.biz.crm.dms.business.costpool.replenishment.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.costpool.replenishment.sdk.vo
 * @ClassName CostPoolReplenishmentOperationVo
 * @Author YangWei
 * @Date 2022/3/23 下午2:42
 * @Description 货补费用池操作明细Vo
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CostPoolReplenishmentOperationVo",description = "货补费用池操作明细Vo")
public class CostPoolReplenishmentOperationVo extends TenantVo {
  private static final long serialVersionUID = 8447664211819800358L;
  /**
   * 费用池编号
   */
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;

  /**
   * 操作记录编号
   */
  @ApiModelProperty(value = "操作记录编号")
  private String operationCode;

  /**
   * 操作类型
   */
  @ApiModelProperty(value = "操作类型")
  private String operationType;

  /**
   * 来源编号
   */
  @ApiModelProperty(value = "来源编号")
  private String fromCode;

  /**
   * 来源描述
   */
  @ApiModelProperty(value = "来源描述")
  private String fromDesc;

  /**
   * 操作时间
   */
  @ApiModelProperty(value = "操作时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date operationDateTime;

  /**
   * 操作金额（数量）（含正负）
   */
  @ApiModelProperty(value = "操作金额（数量）（含正负）")
  private BigDecimal operationAmount;

  /**
   * 货补产品层级编码
   */
  @ApiModelProperty(value = "货补产品层级编码")
  private String goodsProductLevelCode;

  /**
   * 货补产品层级名称
   */
  @ApiModelProperty(value = "货补产品层级名称")
  private String goodsProductLevelName;

  /**
   * 货补商品
   */
  @ApiModelProperty(value = "货补商品")
  private List<CostPoolReplenishmentProductVo> costPoolReplenishmentProduct;
}