package com.biz.crm.dms.business.costpool.replenishment.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author HanJiaJun
 * @describe:用于订单新增货补产品VO
 * @createTime 2022年03月08日 17:01:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用于订单新增货补产品VO")
public class CostPoolReplenishmentOrderProductVo {

  /**
   * 货补池产品子表ID
   */
  @ApiModelProperty(value = "货补池产品子表ID")
  private String id;
  /**
   * 费用池编号
   */
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;
  /**
   * 货补产品层级编码
   */
  @ApiModelProperty(value = "货补产品层级编码")
  private String productLevelCode;
  /**
   * 货补商品编码
   */
  @ApiModelProperty(value = "货补商品编码")
  private String goodsProductCode;
  /**
   * 货补商品名称
   */
  @ApiModelProperty(value = "货补商品名称")
  private String goodsProductName;
  /**
   * 商品单价
   */
  @ApiModelProperty("商品单价")
  private BigDecimal price;

  /** 规格 */
  @ApiModelProperty("规格")
  private String spec;

  /** 基本单位 */
  @ApiModelProperty("基本单位")
  private String baseUnit;

  /** 销售单位 */
  @ApiModelProperty("销售单位")
  private String saleUnit;
}
