package com.biz.crm.dms.business.costpool.replenishment.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.costpool.replenishment.sdk.vo
 * @ClassName CostPoolReplenishmentProductVo
 * @Author YangWei
 * @Date 2022/3/23 下午3:38
 * @Description 货补费用池商品集合Vo
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CostPoolReplenishmentProductVo",description = "货补费用池商品集合Vo")
public class CostPoolReplenishmentProductVo extends UuidVo {
  private static final long serialVersionUID = 6226321364567610006L;

  /**
   * 费用池编号
   */
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;

  /**
   * 货补产品层级编码
   */
  @ApiModelProperty(value = "货补产品层级编码")
  private String productLevelCode;

  /**
   * 货补商品编码
   */
  @ApiModelProperty(value = "货补商品编码")
  private String goodsProductCode;

  /**
   * 货补商品名称
   */
  @ApiModelProperty(value = "货补商品名称")
  private String goodsProductName;
}