package com.biz.crm.dms.business.costpool.replenishment.sdk.vo;

import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 货补费用池VO
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "货补费用池VO")
public class CostPoolReplenishmentVo extends CostPoolVo {
  /**
   * 占用金额（数量）
   */
  @ApiModelProperty(value = "占用金额")
  private BigDecimal occupyAmount;
  /**
   * 货补产品层级编码
   */
  @ApiModelProperty(value = "货补产品层级编码")
  private String goodsProductLevelCode;
  /**
   * 货补产品层级名称
   */
  @ApiModelProperty(value = "货补产品层级名称")
  private String goodsProductLevelName;
  /**
   * 货补商品编码(集合，排序后英文逗号间隔)
   */
  @ApiModelProperty(value = "货补商品编码")
  private String goodsProductCode;
  /**
   * 货补商品名称(集合，排序后英文逗号间隔)
   */
  @ApiModelProperty(value = "货补商品名称")
  private String goodsProductName;

  /**
   * 编码集合
   */
  private List<String> productCodes;

  /**
   * 货补商品集合
   */
  private List<CostPoolReplenishmentOrderProductVo> costPoolReplenishmentProduct;
}
