package com.biz.crm.dms.business.costpool.replenishment.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 费用池分组枚举
 * @author songjingen
 */
public enum PoolGroupEnum {

  DEFAULT("default","default","默认分组","1"),
  ;
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
  PoolGroupEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 CapitalAdjustTypeEnum
   *
   * @param key
   * @return
   */
  public static PoolGroupEnum getByKey(String key) {
    return Arrays.stream(PoolGroupEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

}


