package com.biz.crm.dms.business.costpool.replenishment.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年06月01日 10:27:00
 */

@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "货补费用池商城端统计VO")
public class CostPoolReplenishmentStatisticalVo {

  /**
   * 费用池编号
   */
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;

  /**
   * 货补产品层级编码
   */
  @ApiModelProperty(value = "货补产品层级编码")
  private String goodsProductLevelCode;
  /**
   * 货补产品层级名称
   */
  @ApiModelProperty(value = "货补产品层级名称")
  private String goodsProductLevelName;
  /**
   * 货补商品编码(集合，排序后英文逗号间隔)
   */
  @ApiModelProperty(value = "货补商品编码")
  private String goodsProductCode;
  /**
   * 货补商品名称(集合，排序后英文逗号间隔)
   */
  @ApiModelProperty(value = "货补商品名称")
  private String goodsProductName;

  @ApiModelProperty("上月期末余额")
  private BigDecimal lastEndAmount;

  @ApiModelProperty("本月入账金额")
  private BigDecimal onAmount;

  @ApiModelProperty("本月使用金额")
  private BigDecimal usedAmount;

  @ApiModelProperty("本月占用金额")
  private BigDecimal occupyAmount;

  @ApiModelProperty("当前可用金额")
  private BigDecimal usableAmount;

}
